/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.AcceptorEventListener;
import org.exolab.core.messenger.Connection;
import org.exolab.core.messenger.ConnectionProperties;
import org.exolab.core.messenger.Connector;
import org.exolab.core.messenger.Context;
import org.exolab.core.messenger.Limits;
import org.exolab.core.messenger.ManagedConnection;
import org.exolab.core.messenger.ManagedConnectionAcceptor;
import org.exolab.core.messenger.ManagedConnectionEventListener;
import org.exolab.core.messenger.MessengerException;
import org.exolab.core.messenger.ResourceAllocator;
import org.exolab.core.messenger.tcp.TcpManagedConnection;
import org.exolab.core.messenger.tcp.TcpManagedConnectionAcceptor;
import org.exolab.core.messenger.tcp.URIHelper;
import org.exolab.core.util.URI;

public class TcpConnector
implements Connector,
ManagedConnectionEventListener,
AcceptorEventListener {
    private ResourceAllocator _allocator;
    private Limits _limits = new Limits();
    private HashMap _opened = new HashMap();
    private HashMap _connections = new HashMap();
    private List _accepted = new LinkedList();
    private HashMap _acceptors = new HashMap();
    private static final Log _category = LogFactory.getLog((String)"org.exolab.core.messenger");

    public TcpConnector() {
        this._allocator = new ResourceAllocator(3, this._limits);
    }

    public Connection getConnection(String uri, ConnectionProperties properties) throws MalformedURLException, RemoteException {
        ManagedConnection managed = null;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        URI parser = URIHelper.getURI(uri);
        String address = URIHelper.getAddress(parser);
        String name = parser.getPath();
        TcpConnector tcpConnector = this;
        synchronized (tcpConnector) {
            managed = (ManagedConnection)this._opened.get(address);
        }
        if (managed == null) {
            managed = this.open(address, properties);
        }
        return managed.open(name, properties);
    }

    public synchronized ManagedConnectionAcceptor getManagedConnectionAcceptor(String uri, ConnectionProperties properties) throws MalformedURLException, RemoteException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        URI parser = URIHelper.getURI(uri);
        String address = URIHelper.getAddress(parser);
        ManagedConnectionAcceptor acceptor = (ManagedConnectionAcceptor)this._acceptors.get(address);
        if (acceptor == null) {
            ServerSocket socket;
            try {
                socket = new ServerSocket(parser.getPort());
            }
            catch (IOException exception) {
                throw new MessengerException("Failed to create server socket on port=" + parser.getPort(), exception);
            }
            acceptor = new TcpManagedConnectionAcceptor(this, address, socket);
            acceptor.addAcceptorEventListener(this);
            this._acceptors.put(address, acceptor);
        }
        return acceptor;
    }

    public String getScheme() {
        return "tcp";
    }

    public synchronized void closed(ManagedConnection connection) {
        String uri = (String)this._connections.get(connection);
        if (uri != null) {
            this._opened.remove(uri);
        }
    }

    public synchronized void error(ManagedConnection connection, Exception exception) {
        this._connections.remove(connection);
    }

    public synchronized void closed(ManagedConnectionAcceptor acceptor) {
        this._acceptors.remove(acceptor.getURI());
    }

    public synchronized void error(ManagedConnectionAcceptor acceptor, Exception exception) {
        this._acceptors.remove(acceptor.getURI());
    }

    protected ManagedConnection open(String uri, ConnectionProperties properties) throws MalformedURLException, RemoteException {
        Socket socket;
        URI parser = URIHelper.getURI(uri);
        if (parser.getHost() == null) {
            throw new MalformedURLException("Host not specified in uri");
        }
        try {
            InetAddress address = InetAddress.getByName(parser.getHost());
            socket = new Socket(address, parser.getPort());
        }
        catch (UnknownHostException exception) {
            throw new java.rmi.UnknownHostException(exception.getMessage(), exception);
        }
        catch (IOException exception) {
            throw new ConnectIOException(exception.getMessage(), exception);
        }
        Context context = this._allocator.allocateContext();
        TcpManagedConnection connection = new TcpManagedConnection(context, socket);
        TcpConnector tcpConnector = this;
        synchronized (tcpConnector) {
            this._opened.put(uri, connection);
            this._connections.put(connection, uri);
            connection.setManagedConnectionEventListener(this);
            _category.debug((Object)("Opened connection, uri=" + uri));
        }
        return connection;
    }

    protected TcpManagedConnection accepted(Socket socket, HashMap handlers) throws RemoteException {
        if (socket == null) {
            throw new IllegalArgumentException("Argument 'socket' is null");
        }
        if (handlers == null) {
            throw new IllegalArgumentException("Argument 'handlers' is null");
        }
        Context context = this._allocator.allocateContext();
        TcpManagedConnection connection = new TcpManagedConnection(context, socket, handlers);
        TcpConnector tcpConnector = this;
        synchronized (tcpConnector) {
            this._accepted.add(connection);
        }
        return connection;
    }
}

