/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import org.exolab.core.messenger.Channel;
import org.exolab.core.messenger.PacketChannel;
import org.exolab.core.messenger.PacketConnection;
import org.exolab.core.messenger.PacketQueue;
import org.exolab.core.messenger.SystemChannel;

class SystemPacketChannel
extends PacketChannel
implements SystemChannel {
    public SystemPacketChannel(PacketConnection connection, int channelId, int destinationId, PacketQueue inputQueue) {
        super(connection, channelId, destinationId, inputQueue);
    }

    public Channel open(String name) throws RemoteException {
        OpenResponse response;
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        PacketConnection owner = this.getConnection();
        int channelId = owner.getNextChannelId();
        OpenRequest request = new OpenRequest(name, channelId);
        try {
            response = (OpenResponse)this.invoke(request);
        }
        catch (RemoteException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ServerException(exception.getMessage(), exception);
        }
        int destinationId = response.getChannelId();
        return owner.createChannel(channelId, destinationId);
    }

    public void close(Channel channel) throws RemoteException {
        if (channel == null) {
            throw new IllegalArgumentException("Argument 'channel' is null");
        }
        int channelId = ((PacketChannel)channel).getChannelId();
        Closed request = new Closed(channelId);
        this.send(request);
    }

    public static final class Closed
    implements Serializable {
        static final long serialVersionUID = 1L;
        private int _channelId = -1;

        public Closed() {
        }

        public Closed(int channelId) {
            this._channelId = channelId;
        }

        public int getChannelId() {
            return this._channelId;
        }
    }

    public static final class OpenResponse
    implements Serializable {
        static final long serialVersionUID = 1L;
        private int _channelId = -1;
        private int _destinationId = -1;

        public OpenResponse() {
        }

        public OpenResponse(int channelId, int destinationId) {
            this._channelId = channelId;
            this._destinationId = destinationId;
        }

        public int getChannelId() {
            return this._channelId;
        }

        public int getDestinationId() {
            return this._destinationId;
        }
    }

    public static final class OpenRequest
    implements Serializable {
        static final long serialVersionUID = 1L;
        private String _name = null;
        private int _channelId = -1;

        public OpenRequest() {
        }

        public OpenRequest(String name, int channelId) {
            this._name = name;
            this._channelId = channelId;
        }

        public String getName() {
            return this._name;
        }

        public int getChannelId() {
            return this._channelId;
        }
    }
}

