/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.MarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.ManagedPacketConnection;
import org.exolab.core.messenger.Multiplexer;
import org.exolab.core.messenger.Packet;
import org.exolab.core.messenger.PacketQueue;

public class StreamMultiplexer
implements Multiplexer {
    private ManagedPacketConnection _connection;
    private PacketQueue _queue;
    private OutputStream _stream;
    private volatile boolean _closed = false;
    private Thread _thread = null;
    private static int _threadIdSeed = 0;
    private static final Log _category = LogFactory.getLog((String)"org.exolab.core.messenger");

    public StreamMultiplexer(ManagedPacketConnection connection, OutputStream stream) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' is null");
        }
        this._connection = connection;
        this._stream = stream;
        this._queue = connection.getOutputQueue();
    }

    public synchronized void start() {
        if (this._closed) {
            throw new IllegalStateException("StreamMultiplexer has been closed");
        }
        if (this._thread != null) {
            throw new IllegalStateException("StreamMultiplexer is already running");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                StreamMultiplexer.this.multiplex();
                _category.debug((Object)"StreamMultiplexer terminating");
            }
        };
        String name = "StreamMultiplexer-" + this.getNextId();
        this._thread = new Thread(runnable, name);
        this._thread.start();
    }

    public void close() {
        this._closed = true;
        if (this._thread != null) {
            this._thread.interrupt();
        }
    }

    protected void multiplex() {
        while (!this._closed) {
            Object var5_4;
            Packet packet = this._queue.remove();
            if (packet == null) {
                if (this._closed) continue;
                this._closed = true;
                this._connection.streamClosed();
                continue;
            }
            try {
                try {
                    packet.write(this._stream);
                }
                catch (IOException exception) {
                    if (!this._closed) {
                        this._closed = true;
                        MarshalException wrapper = new MarshalException(exception.getMessage(), exception);
                        this._connection.errorOnStream(wrapper);
                    }
                    var5_4 = null;
                    packet.release();
                    continue;
                }
                var5_4 = null;
                packet.release();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                packet.release();
                throw throwable;
            }
        }
        StreamMultiplexer streamMultiplexer = this;
        synchronized (streamMultiplexer) {
            this._thread = null;
            this._connection = null;
            this._stream = null;
            this._queue = null;
        }
    }

    private synchronized int getNextId() {
        return ++_threadIdSeed;
    }
}

