/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.Demultiplexer;
import org.exolab.core.messenger.ManagedPacketConnection;
import org.exolab.core.messenger.Packet;
import org.exolab.core.messenger.PacketChannel;
import org.exolab.core.messenger.PacketPool;

public class StreamDemultiplexer
implements Demultiplexer {
    private ManagedPacketConnection _connection;
    private InputStream _stream;
    private PacketPool _pool;
    private volatile boolean _closed = false;
    private Thread _thread = null;
    private static int _threadIdSeed = 0;
    private static final Log _category = LogFactory.getLog((String)"org.exolab.core.messenger");

    public StreamDemultiplexer(ManagedPacketConnection connection, InputStream stream) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' is null");
        }
        this._connection = connection;
        this._stream = stream;
        this._pool = connection.getPool();
    }

    public synchronized void start() {
        if (this._closed) {
            throw new IllegalStateException("StreamDemultiplexer has been closed");
        }
        if (this._thread != null) {
            throw new IllegalStateException("StreamDemultiplexer is already running");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                StreamDemultiplexer.this.demultiplex();
                _category.debug((Object)"StreamDemultiplexer terminating");
            }
        };
        String name = "StreamDemultiplexer-" + this.getNextId();
        this._thread = new Thread(runnable, name);
        this._thread.start();
    }

    public synchronized void close() {
        this._closed = true;
        if (this._thread != null) {
            this._thread.interrupt();
        }
    }

    public synchronized boolean closed() {
        return this._closed;
    }

    protected void demultiplex() {
        while (!this.closed()) {
            Packet packet = this._pool.allocate();
            if (packet == null) {
                if (this._closed) continue;
                this._closed = true;
                this._connection.streamClosed();
                continue;
            }
            try {
                if (packet.read(this._stream) != -1) {
                    this.dispatch(packet);
                    continue;
                }
                if (this._closed) continue;
                this._closed = true;
                this._connection.streamClosed();
            }
            catch (IOException exception) {
                if (this._closed) continue;
                this._closed = true;
                UnmarshalException wrapper = new UnmarshalException(exception.getMessage(), exception);
                this._connection.errorOnStream(wrapper);
            }
        }
        StreamDemultiplexer streamDemultiplexer = this;
        synchronized (streamDemultiplexer) {
            this._thread = null;
            this._connection = null;
            this._stream = null;
            this._pool = null;
        }
    }

    protected void dispatch(Packet packet) {
        int channelId;
        int connectionId = packet.getConnectionId();
        PacketChannel channel = (PacketChannel)this._connection.getChannel(connectionId, channelId = packet.getDestinationId());
        if (channel != null) {
            channel.enqueue(packet);
        } else {
            _category.debug((Object)("StreamDemultiplexer tossed a packet for non existent channel, connection id=" + connectionId + ", channel id=" + channelId));
        }
    }

    private synchronized int getNextId() {
        return ++_threadIdSeed;
    }
}

