/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.util.LinkedList;
import org.exolab.core.messenger.Packet;

public class PacketQueue {
    private LinkedList _queue = new LinkedList();
    private boolean _closed = false;
    private int _limit = 0;

    public PacketQueue() {
    }

    public PacketQueue(int limit) {
        this._limit = limit;
    }

    public void add(Packet packet) {
        if (packet == null) {
            throw new IllegalArgumentException("Argument 'packet' is null");
        }
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (this._limit != 0) {
                while (!this._closed && this._queue.size() >= this._limit) {
                    try {
                        this._queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this._closed) {
                this._queue.add(packet);
                this._queue.notify();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Packet remove() {
        Packet packet = null;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            while (!this._closed && this._queue.isEmpty()) {
                try {
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this._closed) return packet;
            packet = (Packet)this._queue.removeFirst();
            this._queue.notify();
            return packet;
        }
    }

    public Packet peek() {
        Packet packet = null;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (!this._closed && !this._queue.isEmpty()) {
                packet = (Packet)this._queue.getFirst();
            }
        }
        return packet;
    }

    public boolean waitForPacket(long timeout) {
        boolean available = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (!this._closed && this._queue.isEmpty()) {
                try {
                    if (timeout == 0L) {
                        this._queue.wait();
                    } else {
                        this._queue.wait(timeout);
                    }
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (!this._closed && !this._queue.isEmpty()) {
                available = true;
            }
        }
        return available;
    }

    public boolean isEmpty() {
        boolean empty = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            empty = this._queue.isEmpty();
        }
        return empty;
    }

    public void close() {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._closed = true;
            this._queue.notifyAll();
        }
    }

    public boolean isClosed() {
        boolean closed = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            closed = this._closed;
        }
        return closed;
    }
}

