/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.util.LinkedList;
import org.exolab.core.messenger.Packet;

class PacketPool {
    private final int _packetSize;
    private int _allocated = 0;
    private final int _limit;
    private LinkedList _packets;
    private boolean _closed = false;

    public PacketPool(int packetSize) {
        this(packetSize, 0);
    }

    public PacketPool(int packetSize, int limit) {
        this._packetSize = packetSize;
        this._limit = limit;
        this._packets = new LinkedList();
    }

    public Packet allocate() {
        Packet packet = null;
        LinkedList linkedList = this._packets;
        synchronized (linkedList) {
            if (this._packets.isEmpty() && (this._limit <= 0 || this._allocated < this._limit)) {
                ++this._allocated;
                packet = new Packet(this._packetSize, this);
            }
            if (packet == null) {
                while (!this._closed && this._packets.isEmpty()) {
                    try {
                        this._packets.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this._closed) {
                    packet = (Packet)this._packets.removeFirst();
                }
            }
        }
        return packet;
    }

    public void release(Packet packet) {
        LinkedList linkedList = this._packets;
        synchronized (linkedList) {
            if (!this._closed) {
                this._packets.add(packet);
                this._packets.notify();
            }
        }
    }

    public boolean isEmpty() {
        boolean empty;
        LinkedList linkedList = this._packets;
        synchronized (linkedList) {
            empty = this._packets.isEmpty();
        }
        return empty;
    }

    public void close() {
        LinkedList linkedList = this._packets;
        synchronized (linkedList) {
            this._closed = true;
            this._packets.clear();
            this._packets.notifyAll();
        }
    }

    public boolean isClosed() {
        boolean closed;
        LinkedList linkedList = this._packets;
        synchronized (linkedList) {
            closed = this._closed;
        }
        return closed;
    }
}

