/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.IOException;
import java.io.OutputStream;
import org.exolab.core.messenger.Packet;
import org.exolab.core.messenger.PacketPool;
import org.exolab.core.messenger.PacketQueue;

class PacketOutputStream
extends OutputStream {
    private byte _type = 0;
    private int _connectionId;
    private int _channelId;
    private int _destinationId;
    private PacketQueue _queue;
    private PacketPool _pool;
    private Packet _packet = null;
    private byte[] _data = null;
    private int _position = 0;

    public PacketOutputStream(int connectionId, int channelId, int destinationId, PacketQueue queue, PacketPool pool) {
        if (queue == null) {
            throw new IllegalArgumentException("Argument 'queue' is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Argument 'pool' is null");
        }
        this._connectionId = connectionId;
        this._channelId = channelId;
        this._destinationId = destinationId;
        this._queue = queue;
        this._pool = pool;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this._queue == null) {
            throw new IOException("PacketOutputStream has been closed");
        }
        if (this._packet != null) {
            this.queue();
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._queue == null) {
            throw new IOException("PacketOutputStream has been closed");
        }
        int remaining = length;
        while (remaining > 0) {
            int space;
            if (this._packet == null || this._position == this._data.length) {
                this.load();
            }
            int toCopy = remaining <= (space = this._data.length - this._position) ? remaining : space;
            System.arraycopy(buffer, offset, this._data, this._position, toCopy);
            this._position += toCopy;
            offset += toCopy;
            remaining -= toCopy;
            if (this._position != this._data.length) continue;
            this.queue();
        }
    }

    public void write(int value) throws IOException {
        if (this._queue == null) {
            throw new IOException("PacketOutputStream has been closed");
        }
        if (this._packet == null || this._position == this._data.length) {
            this.load();
        }
        this._data[this._position++] = (byte)value;
        if (this._position == this._data.length) {
            this.queue();
        }
    }

    public void setType(byte type) {
        this._type = type;
    }

    public void setDestinationId(int destinationId) {
        this._destinationId = destinationId;
    }

    private void load() throws IOException {
        this._packet = this._pool.allocate();
        if (this._packet == null) {
            throw new IOException("PacketPool has been closed");
        }
        this._data = this._packet.getData();
        this._position = this._packet.getHeaderSize();
        this._packet.setType(this._type);
        this._packet.setConnectionId(this._connectionId);
        this._packet.setChannelId(this._channelId);
        this._packet.setDestinationId(this._destinationId);
    }

    private void queue() {
        this._packet.setSize(this._position);
        this._queue.add(this._packet);
        this._packet = null;
        this._data = null;
    }
}

