/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.IOException;
import java.io.InputStream;
import org.exolab.core.messenger.Packet;
import org.exolab.core.messenger.PacketQueue;

class PacketInputStream
extends InputStream {
    private PacketQueue _queue;
    private Packet _packet = null;
    private byte _type = 0;
    private byte[] _data = null;
    private int _position = 0;
    private int _size;

    public PacketInputStream(PacketQueue queue) {
        if (queue == null) {
            throw new IllegalArgumentException("Argument queue is null");
        }
        this._queue = queue;
    }

    public void close() {
        if (this._packet != null) {
            this._packet.release();
            this._packet = null;
        }
    }

    public int read() throws IOException {
        if (this._queue == null) {
            throw new IOException("PacketInputStream has been closed");
        }
        if (this._packet == null || this._position >= this._size) {
            this.load();
        }
        return this._position < this._size ? this._data[this._position++] & 0xFF : -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = -1;
        if (buffer == null) {
            throw new NullPointerException("Argument 'buffer' is null");
        }
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            result = 0;
        } else {
            if (this._queue == null) {
                throw new IOException("PacketInputStream has been closed");
            }
            int remaining = length;
            boolean done = false;
            while (remaining > 0 && !done) {
                if (this._packet == null || this._position == this._size) {
                    this.load();
                }
                if (this._packet == null) {
                    done = true;
                    continue;
                }
                int count = this._size - this._position;
                int toCopy = remaining <= count ? remaining : count;
                System.arraycopy(this._data, this._position, buffer, offset, toCopy);
                this._position += toCopy;
                offset += toCopy;
                remaining -= toCopy;
            }
            result = length - remaining;
        }
        return result;
    }

    public int available() throws IOException {
        if (this._queue == null) {
            throw new IOException("PacketInputStream has been closed");
        }
        return this._packet != null ? this._data.length - this._position : 0;
    }

    public byte getType() {
        return this._type;
    }

    private void load() {
        if (this._packet != null) {
            this._packet.release();
        }
        this._packet = this._queue.remove();
        if (this._packet != null) {
            this._data = this._packet.getData();
            this._position = this._packet.getHeaderSize();
            this._size = this._packet.getSize();
            this._type = this._packet.getType();
        }
    }
}

