/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.ChannelListener;
import org.exolab.core.messenger.ConnectionAcceptor;
import org.exolab.core.messenger.ConnectionHandler;
import org.exolab.core.messenger.ManagedPacketConnection;
import org.exolab.core.messenger.MessengerException;
import org.exolab.core.messenger.PacketConnection;

class PacketConnectionAcceptor
implements ConnectionAcceptor,
ChannelListener {
    private ManagedPacketConnection _connection;
    private HashMap _handlers = new HashMap();
    private static final Log _category = LogFactory.getLog((String)"org.exolab.core.messenger");

    public PacketConnectionAcceptor(ManagedPacketConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        this._connection = connection;
    }

    public synchronized void accept(String name, ConnectionHandler handler) throws RemoteException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null");
        }
        if (this._handlers.containsKey(name)) {
            throw new MessengerException("A handler is already registered for " + name);
        }
        this._handlers.put(name, handler);
    }

    public synchronized void close(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        this._handlers.remove(name);
    }

    public synchronized void close() {
        if (this._handlers != null) {
            this._handlers.clear();
            this._connection = null;
            this._handlers = null;
        }
    }

    public void receive(Object message) {
        _category.error((Object)("PacketConnectionAcceptor cannot handle async messages of type=" + message.getClass().getName()));
    }

    public Object invoke(Object request) throws Exception {
        ManagedPacketConnection.ConnectResponse response = null;
        if (!(request instanceof ManagedPacketConnection.ConnectRequest)) {
            throw new MessengerException("ConnectionListener cannot handle synchronous requests of type=" + request.getClass().getName());
        }
        response = this.connect((ManagedPacketConnection.ConnectRequest)request);
        return response;
    }

    public void closed() {
        this.close();
    }

    protected synchronized ManagedPacketConnection.ConnectResponse connect(ManagedPacketConnection.ConnectRequest request) throws Exception {
        String name = request.getName();
        ConnectionHandler handler = (ConnectionHandler)this._handlers.get(name);
        if (handler == null) {
            throw new ConnectException("Connection refused");
        }
        PacketConnection local = this._connection.createConnection(request.getName());
        handler.connected(local);
        return new ManagedPacketConnection.ConnectResponse(local.getConnectionId());
    }
}

