/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.Channel;
import org.exolab.core.messenger.ChannelAcceptor;
import org.exolab.core.messenger.ChannelHandler;
import org.exolab.core.messenger.ChannelListener;
import org.exolab.core.messenger.Connection;
import org.exolab.core.messenger.ConnectionEventListener;
import org.exolab.core.messenger.ConnectionEventNotifier;
import org.exolab.core.messenger.ManagedPacketConnection;
import org.exolab.core.messenger.PacketChannel;
import org.exolab.core.messenger.PacketChannelAcceptor;
import org.exolab.core.messenger.PacketPool;
import org.exolab.core.messenger.PacketQueue;
import org.exolab.core.messenger.SystemPacketChannel;
import org.exolab.core.threadPool.ThreadPool;

public class PacketConnection
implements Connection {
    private ManagedPacketConnection _owner;
    private final int _connectionId;
    private HashMap _channels = new HashMap();
    private SystemPacketChannel _systemChannel;
    private PacketChannel _acceptorChannel;
    private ChannelAcceptor _acceptor;
    private PacketQueue _queue;
    private ThreadPool _threads;
    private PacketPool _pool;
    private ConnectionEventNotifier _listeners = new ConnectionEventNotifier();
    private int _channelIdSeed = 5;
    private boolean _closed = false;
    private static final Log _category = LogFactory.getLog((String)"org.exolab.core.messenger");

    public PacketConnection(ManagedPacketConnection owner, int connectionId) throws RemoteException {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 'owner' is null");
        }
        this._owner = owner;
        this._connectionId = connectionId;
        this._queue = this._owner.getOutputQueue();
        this._threads = this._owner.getThreadPool();
        this._pool = this._owner.getPool();
        this._systemChannel = this.createSystemChannel();
        this._acceptorChannel = this.createChannel(3, 2);
        this._acceptor = new PacketChannelAcceptor(this, this._acceptorChannel);
        this._acceptorChannel.setChannelListener((ChannelListener)((Object)this._acceptor));
    }

    public int getConnectionId() {
        return this._connectionId;
    }

    public Channel open(String name) throws RemoteException {
        SystemPacketChannel channel;
        PacketConnection packetConnection = this;
        synchronized (packetConnection) {
            this.ensureOpen();
            channel = this._systemChannel;
        }
        return channel.open(name);
    }

    public synchronized void accept(String name, ChannelHandler handler) throws RemoteException {
        this.ensureOpen();
        this._acceptor.accept(name, handler);
    }

    public synchronized void accept(String name, ChannelListener listener) throws RemoteException {
        this.ensureOpen();
        this._acceptor.accept(name, listener);
    }

    public synchronized void close(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        if (this._acceptor != null) {
            this._acceptor.close(name);
        }
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this._listeners != null) {
            this._listeners.addConnectionEventListener(listener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this._listeners != null) {
            this._listeners.removeConnectionEventListener(listener);
        }
    }

    public void close() throws RemoteException {
        ConnectionEventNotifier listeners;
        PacketConnection packetConnection = this;
        synchronized (packetConnection) {
            listeners = this._listeners;
        }
        if (listeners != null) {
            _category.debug((Object)("Closing connection, id=" + this._connectionId));
            try {
                this.doClose();
                Object var5_4 = null;
                listeners.closed(this);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                listeners.closed(this);
                throw throwable;
            }
        }
    }

    protected synchronized void doClose() throws RemoteException {
        if (!this._closed) {
            this._closed = true;
            if (this._systemChannel != null) {
                this._systemChannel.close();
                this._systemChannel = null;
            }
            if (this._acceptorChannel != null) {
                this._acceptorChannel.close();
                this._acceptorChannel = null;
            }
            this._queue = null;
            this._pool = null;
            this._threads = null;
            this._listeners = null;
        }
    }

    protected synchronized Channel getChannel(int channelId) {
        Channel result = null;
        if (this._channels != null) {
            result = (Channel)this._channels.get(new Integer(channelId));
        }
        return result;
    }

    protected synchronized PacketQueue getOutputQueue() {
        return this._queue;
    }

    protected synchronized PacketPool getPool() {
        return this._pool;
    }

    protected synchronized ThreadPool getThreadPool() {
        return this._threads;
    }

    protected synchronized PacketChannel createChannel(int channelId, int destinationId) throws RemoteException {
        this.ensureOpen();
        PacketQueue input = new PacketQueue();
        PacketChannel channel = new PacketChannel(this, channelId, destinationId, input);
        this._channels.put(new Integer(channelId), channel);
        return channel;
    }

    protected synchronized void closed(PacketChannel channel) throws RemoteException {
        Integer id;
        if (!this._closed && this._channels.remove(id = new Integer(channel.getChannelId())) != null && channel.getChannelId() <= 4) {
            this._systemChannel.close(channel);
        }
    }

    protected synchronized int getNextChannelId() {
        return ++this._channelIdSeed;
    }

    protected synchronized void ensureOpen() throws RemoteException {
        if (this._closed) {
            throw new RemoteException("Connection is closed");
        }
    }

    private SystemPacketChannel createSystemChannel() {
        PacketQueue input = new PacketQueue();
        SystemPacketChannel result = new SystemPacketChannel(this, 2, 3, input);
        this._channels.put(new Integer(2), result);
        return result;
    }
}

