/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.ChannelAcceptor;
import org.exolab.core.messenger.ChannelHandler;
import org.exolab.core.messenger.ChannelListener;
import org.exolab.core.messenger.ChannelListenerAcceptor;
import org.exolab.core.messenger.InvalidChannelException;
import org.exolab.core.messenger.MessengerException;
import org.exolab.core.messenger.PacketChannel;
import org.exolab.core.messenger.PacketConnection;
import org.exolab.core.messenger.SystemPacketChannel;

class PacketChannelAcceptor
implements ChannelAcceptor,
ChannelListener {
    private PacketConnection _connection;
    private PacketChannel _channel;
    private HashMap _handlers = new HashMap();
    private HashMap _channels = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$messenger$PacketChannelAcceptor == null ? (class$org$exolab$core$messenger$PacketChannelAcceptor = PacketChannelAcceptor.class$("org.exolab.core.messenger.PacketChannelAcceptor")) : class$org$exolab$core$messenger$PacketChannelAcceptor));
    static /* synthetic */ Class class$org$exolab$core$messenger$PacketChannelAcceptor;

    public PacketChannelAcceptor(PacketConnection connection, PacketChannel channel) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Argument 'channel' is null");
        }
        this._connection = connection;
        this._channel = channel;
    }

    public synchronized void accept(String name, ChannelHandler handler) throws RemoteException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null");
        }
        if (this._handlers.containsKey(name)) {
            throw new MessengerException("A handler is already registered for " + name);
        }
        this._handlers.put(name, handler);
        _log.debug((Object)("Connection id=" + this._connection.getConnectionId() + " accepting requests on channel=" + name));
    }

    public synchronized void accept(String name, ChannelListener listener) throws RemoteException {
        this.accept(name, new ChannelListenerAcceptor(this._connection, name, listener));
    }

    public synchronized void close(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        this._handlers.remove(name);
    }

    public synchronized void receive(Object message) {
        if (message instanceof SystemPacketChannel.Closed) {
            this.closed((SystemPacketChannel.Closed)message);
        } else {
            _log.error((Object)("Cannot process messages of type=" + message.getClass().getName()));
        }
    }

    public synchronized Object invoke(Object request) throws RemoteException {
        Object response = null;
        if (!(request instanceof SystemPacketChannel.OpenRequest)) {
            throw new MessengerException("Cannot process requests of type=" + request.getClass().getName());
        }
        response = this.open((SystemPacketChannel.OpenRequest)request);
        return response;
    }

    public void closed() {
        this.close();
    }

    public synchronized void close() {
        if (this._handlers != null) {
            this._handlers.clear();
            this._channels.clear();
            this._connection = null;
            this._channel = null;
            this._handlers = null;
            this._channels = null;
        }
    }

    protected Object open(SystemPacketChannel.OpenRequest request) throws RemoteException {
        ChannelHandler handler = (ChannelHandler)this._handlers.get(request.getName());
        if (handler == null) {
            throw new InvalidChannelException("No ChannelHandler registered for channel=" + request.getName());
        }
        int channelId = this._connection.getNextChannelId();
        int destinationId = request.getChannelId();
        PacketChannel opened = this._connection.createChannel(channelId, destinationId);
        this._channels.put(new Integer(destinationId), opened);
        handler.opened(opened);
        SystemPacketChannel.OpenResponse response = new SystemPacketChannel.OpenResponse(channelId, destinationId);
        return response;
    }

    protected void closed(SystemPacketChannel.Closed message) {
        Integer channelId = new Integer(message.getChannelId());
        PacketChannel channel = (PacketChannel)this._channels.remove(channelId);
        channel.doClose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

