/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.Channel;
import org.exolab.core.messenger.ChannelClosedException;
import org.exolab.core.messenger.ChannelListener;
import org.exolab.core.messenger.MessengerException;
import org.exolab.core.messenger.Packet;
import org.exolab.core.messenger.PacketConnection;
import org.exolab.core.messenger.PacketInputStream;
import org.exolab.core.messenger.PacketOutputStream;
import org.exolab.core.messenger.PacketPool;
import org.exolab.core.messenger.PacketQueue;
import org.exolab.core.messenger.ReceiveTimeoutException;
import org.exolab.core.threadPool.CompletionListener;
import org.exolab.core.threadPool.ThreadPool;

public class PacketChannel
implements Channel {
    public static final int CONNECTION_CHANNEL_ID = 0;
    public static final int CONNECTION_ACCEPT_CHANNEL_ID = 1;
    public static final int SYSTEM_CHANNEL_ID = 2;
    public static final int ACCEPTOR_CHANNEL_ID = 3;
    public static final int HANDSHAKE_CHANNEL_ID = 4;
    public static final int LAST_SYSTEM_ID = 4;
    private PacketConnection _connection;
    private final int _channelId;
    private int _destinationId;
    private PacketQueue _outQueue;
    private PacketQueue _inQueue;
    private PacketPool _pool;
    private PacketOutputStream _out;
    private PacketInputStream _in;
    private ChannelListener _listener;
    private ThreadPool _threads;
    private boolean _closed = false;
    private final Object _lock = new Object();
    private boolean _scheduled = false;
    private boolean _invoke = false;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$messenger$PacketChannel == null ? (class$org$exolab$core$messenger$PacketChannel = PacketChannel.class$("org.exolab.core.messenger.PacketChannel")) : class$org$exolab$core$messenger$PacketChannel));
    static /* synthetic */ Class class$org$exolab$core$messenger$PacketChannel;

    public PacketChannel(PacketConnection connection, int channelId, int destinationId, PacketQueue inputQueue) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (inputQueue == null) {
            throw new IllegalArgumentException("Argument 'inputQueue' is null");
        }
        this._connection = connection;
        this._channelId = channelId;
        this._destinationId = destinationId;
        this._inQueue = inputQueue;
        this._outQueue = this._connection.getOutputQueue();
        this._pool = this._connection.getPool();
        this._threads = this._connection.getThreadPool();
        this._out = new PacketOutputStream(this._connection.getConnectionId(), this._channelId, this._destinationId, this._outQueue, this._pool);
        this._in = new PacketInputStream(this._inQueue);
    }

    public int getChannelId() {
        return this._channelId;
    }

    public void send(Object message) throws RemoteException {
        this.send(message, (byte)0, this._destinationId);
    }

    public Object receive() throws RemoteException {
        return this.receive(0L);
    }

    public synchronized Object receive(long timeout) throws RemoteException {
        if (this._listener != null) {
            throw new MessengerException("Cannot receive - a ChannelListener is registered");
        }
        Object message = this.doReceive(timeout);
        byte type = this._in.getType();
        if (type == 1) {
            throw new MessengerException("Expected data packet, but got an invocation request");
        }
        if (type == 2) {
            throw new MessengerException("Expected data packet, but got an invocation response");
        }
        if (type == 3) {
            throw (RemoteException)message;
        }
        return message;
    }

    public synchronized Object invoke(Object request) throws Exception, RemoteException {
        Object response;
        if (this._closed) {
            throw new ChannelClosedException();
        }
        if (this._invoke) {
            throw new MessengerException("Cannot call Channel.invoke() while ChannelListener.invoke()  in progress");
        }
        this._out.setType((byte)1);
        try {
            ObjectOutputStream out = new ObjectOutputStream(this._out);
            out.writeObject(request);
            out.close();
        }
        catch (IOException exception) {
            throw new MarshalException("Failed to perform invocation", exception);
        }
        try {
            ObjectInputStream in = new ObjectInputStream(this._in);
            response = in.readObject();
            in.close();
        }
        catch (Exception exception) {
            throw new UnmarshalException("Failed to deserialize response", exception);
        }
        byte type = this._in.getType();
        if (type == 0) {
            throw new MessengerException("Expected reponse packet, but got an data packet");
        }
        if (type == 1) {
            throw new MessengerException("Expected reponse packet, but got an invocation request");
        }
        if (type == 3) {
            throw (Exception)response;
        }
        return response;
    }

    public synchronized void setChannelListener(ChannelListener listener) {
        this._listener = listener;
    }

    public void close() throws RemoteException {
        Object object = this._lock;
        synchronized (object) {
            if (!this._closed) {
                this._connection.closed(this);
            }
        }
        this.doClose();
    }

    public synchronized boolean isClosed() {
        return this._closed;
    }

    protected synchronized Object doReceive(long timeout) throws RemoteException {
        Object message;
        if (this._closed) {
            throw new ChannelClosedException();
        }
        if (this._invoke) {
            throw new MessengerException("Cannot receive messages on channel while ChannelListener.invoke() is in progress");
        }
        if (timeout != 0L) {
            if (!this._inQueue.waitForPacket(timeout)) {
                throw new ReceiveTimeoutException();
            }
        } else if (!this._inQueue.waitForPacket(0L)) {
            throw new ChannelClosedException();
        }
        try {
            ObjectInputStream in = new ObjectInputStream(this._in);
            message = in.readObject();
            in.close();
        }
        catch (Exception exception) {
            throw new UnmarshalException("Failed to receive message", exception);
        }
        return message;
    }

    protected void doClose() {
        this.closeListener();
        PacketChannel packetChannel = this;
        synchronized (packetChannel) {
            if (!this._closed) {
                this._closed = true;
                if (this._listener != null) {
                    this._listener.closed();
                }
                this._connection = null;
                this._outQueue = null;
                this._inQueue = null;
                this._pool = null;
                this._out = null;
                this._in = null;
                this._listener = null;
            }
        }
    }

    protected void closeListener() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._closed) {
                this._inQueue.close();
            }
        }
    }

    protected synchronized void setInvoke(boolean invoke) {
        this._invoke = invoke;
    }

    protected synchronized PacketConnection getConnection() {
        return this._connection;
    }

    protected synchronized void send(Object message, byte type, int destinationId) throws RemoteException {
        if (this._closed) {
            throw new ChannelClosedException();
        }
        if (this._invoke) {
            throw new MessengerException("Cannot send messages on channel while ChannelListener.invoke() is in progress");
        }
        this._out.setType(type);
        this._out.setDestinationId(destinationId);
        try {
            ObjectOutputStream out = new ObjectOutputStream(this._out);
            out.writeObject((Serializable)message);
            out.close();
        }
        catch (IOException exception) {
            throw new MarshalException("Failed to send message", exception);
        }
    }

    protected void enqueue(Packet packet) {
        Object object = this._lock;
        synchronized (object) {
            if (!this._closed) {
                this._inQueue.add(packet);
                if (this._listener != null && !this._scheduled) {
                    this._scheduled = true;
                    ListenerInvoker invoker = new ListenerInvoker(this._listener, packet.getType(), packet.getChannelId());
                    this._threads.queue(invoker, new CompletionHandler());
                }
            }
        }
    }

    protected synchronized void handlerCompleted() {
        if (!this._closed) {
            Packet packet = this._inQueue.peek();
            if (packet != null) {
                ListenerInvoker invoker = new ListenerInvoker(this._listener, packet.getType(), packet.getChannelId());
                this._threads.queue(invoker, new CompletionHandler());
            } else {
                this._scheduled = false;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ListenerInvoker
    implements Runnable {
        private ChannelListener _listener;
        private byte _type;
        private int _destinationId;

        public ListenerInvoker(ChannelListener handler, byte type, int destinationId) {
            this._listener = handler;
            this._type = type;
            this._destinationId = destinationId;
        }

        public void run() {
            try {
                PacketChannel packetChannel = PacketChannel.this;
                synchronized (packetChannel) {
                    Object request = PacketChannel.this.doReceive(0L);
                    Object object = PacketChannel.this._lock;
                    synchronized (object) {
                        if (this._type == 0) {
                            this._listener.receive(request);
                        } else if (this._type == 1) {
                            Object response;
                            try {
                                PacketChannel.this.setInvoke(true);
                                response = this._listener.invoke(request);
                                Object var6_10 = null;
                                PacketChannel.this.setInvoke(false);
                            }
                            catch (Throwable throwable) {
                                Object var6_11 = null;
                                PacketChannel.this.setInvoke(false);
                                throw throwable;
                            }
                            PacketChannel.this.send(response, (byte)2, this._destinationId);
                        }
                    }
                }
            }
            catch (ChannelClosedException ignore) {
            }
            catch (Exception exception2) {
                UnexpectedException exception2;
                if (!(exception2 instanceof RemoteException)) {
                    exception2 = new UnexpectedException(exception2.getMessage(), exception2);
                }
                Object object = PacketChannel.this._lock;
                synchronized (object) {
                    if (!PacketChannel.this._closed) {
                        try {
                            _log.debug((Object)("sending exception on connection=" + PacketChannel.this.getConnection().getConnectionId() + ", channel=" + this._destinationId));
                            PacketChannel.this.send(exception2, (byte)3, this._destinationId);
                        }
                        catch (RemoteException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private class CompletionHandler
    implements CompletionListener {
        private CompletionHandler() {
        }

        public void completed(Runnable target) {
            PacketChannel.this.handlerCompleted();
        }
    }
}

