/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.PacketPool;

class Packet {
    public static final byte TC_DATA = 0;
    public static final byte TC_REQUEST = 1;
    public static final byte TC_RESPONSE = 2;
    public static final byte TC_EXCEPTION = 3;
    protected static final short PACKET_MAGIC = -13570;
    protected static final short PACKET_VERSION = 1;
    protected static final int MAGIC_OFFSET = 0;
    protected static final int VERSION_OFFSET = 2;
    protected static final int SIZE_OFFSET = 4;
    protected static final int TYPE_OFFSET = 8;
    protected static final int CONNECTION_OFFSET = 9;
    protected static final int CHANNEL_OFFSET = 13;
    protected static final int DESTINATION_OFFSET = 17;
    protected static final int DATA_OFFSET = 21;
    private PacketPool _pool;
    private byte[] _data;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$messenger$Packet == null ? (class$org$exolab$core$messenger$Packet = Packet.class$("org.exolab.core.messenger.Packet")) : class$org$exolab$core$messenger$Packet));
    static /* synthetic */ Class class$org$exolab$core$messenger$Packet;

    protected Packet(int size, PacketPool pool) {
        this._data = new byte[size];
        this._pool = pool;
        this.setShort(0, (short)-13570);
        this.setShort(2, (short)1);
    }

    public void setType(byte type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Argument 'type' is invalid");
        }
        this._data[8] = type;
    }

    public byte getType() {
        return this._data[8];
    }

    public void setConnectionId(int id) {
        this.setInt(9, id);
    }

    public int getConnectionId() {
        return this.getInt(9);
    }

    public void setChannelId(int id) {
        this.setInt(13, id);
    }

    public int getChannelId() {
        return this.getInt(13);
    }

    public void setDestinationId(int id) {
        this.setInt(17, id);
    }

    public int getDestinationId() {
        return this.getInt(17);
    }

    public void setSize(int size) {
        if (size > this._data.length) {
            throw new IllegalArgumentException("Argument 'size' is invalid");
        }
        this.setInt(4, size);
    }

    public int getSize() {
        return this.getInt(4);
    }

    public byte[] getData() {
        return this._data;
    }

    public int getHeaderSize() {
        return 21;
    }

    public void release() {
        if (this._pool != null) {
            this._pool.release(this);
        }
    }

    public int read(InputStream stream) throws IOException {
        int headerSize = this.getHeaderSize();
        if (headerSize > this._data.length) {
            throw new IOException("Cannot destream packet. Packet too large");
        }
        int count = stream.read(this._data, 0, headerSize);
        if (count != -1) {
            int tmp;
            if (count != headerSize) {
                throw new IOException("Failed to read packet header. Expected header size=" + headerSize + ", but read=" + count);
            }
            this.checkHeader();
            int size = this.getSize();
            if (size > this._data.length) {
                throw new IOException("Cannot destream packet. Packet too large");
            }
            if (size < headerSize) {
                throw new IOException("Packet size is invalid");
            }
            int expect = size - headerSize;
            int actual = stream.read(this._data, headerSize, expect);
            if (actual != expect && actual != -1 && (tmp = stream.read(this._data, headerSize + actual, expect - actual)) + actual != expect) {
                throw new IOException("Failed to read packet. Expected to read size=" + expect + ", but read=" + actual);
            }
            count += expect;
        }
        return count;
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this._data, 0, this.getSize());
    }

    protected void checkHeader() throws IOException {
        short magic = this.getShort(0);
        short version = this.getShort(2);
        if (magic != -13570) {
            throw new IOException("Stream does not contain a packet");
        }
        if (version != 1) {
            throw new IOException("Packet version mismatch. Expected version=1, but got version=" + version);
        }
    }

    protected void setShort(int offset, short value) {
        this._data[offset] = (byte)(value >>> 8 & 0xFF);
        this._data[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    protected short getShort(int offset) {
        return (short)(((this._data[offset] & 0xFF) << 8) + ((this._data[offset + 1] & 0xFF) << 0));
    }

    protected void setInt(int offset, int value) {
        this._data[offset] = (byte)(value >>> 24 & 0xFF);
        this._data[offset + 1] = (byte)(value >>> 16 & 0xFF);
        this._data[offset + 2] = (byte)(value >>> 8 & 0xFF);
        this._data[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    protected int getInt(int offset) {
        return ((this._data[offset] & 0xFF) << 24) + ((this._data[offset + 1] & 0xFF) << 16) + ((this._data[offset + 2] & 0xFF) << 8) + ((this._data[offset + 3] & 0xFF) << 0);
    }

    protected static void dump(String prefix, Packet packet) {
        int size = packet.getSize();
        byte[] data = packet.getData();
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append(" packet length=" + size + ", type=" + packet.getType() + ", channel=" + packet.getChannelId() + ", data=");
        int i = 0;
        while (i < size) {
            int value = data[i] & 0xFF;
            buffer.append(Integer.toHexString(value));
            buffer.append(" ");
            ++i;
        }
        _log.debug((Object)buffer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

