/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.AcceptorEventListener;
import org.exolab.core.messenger.Connection;
import org.exolab.core.messenger.ConnectionDispatcher;
import org.exolab.core.messenger.ConnectionHandler;
import org.exolab.core.messenger.ConnectionProperties;
import org.exolab.core.messenger.Connector;
import org.exolab.core.messenger.ManagedConnectionAcceptor;
import org.exolab.core.messenger.tcp.TcpConnector;

public class Messenger {
    private static Messenger _instance = new Messenger();
    private Connector _tcp = new TcpConnector();
    private HashMap _dispatchers = new HashMap();
    private HashMap _acceptors = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$messenger$Messenger == null ? (class$org$exolab$core$messenger$Messenger = Messenger.class$("org.exolab.core.messenger.Messenger")) : class$org$exolab$core$messenger$Messenger));
    static /* synthetic */ Class class$org$exolab$core$messenger$Messenger;

    protected Messenger() {
    }

    public static Messenger getInstance() {
        return _instance;
    }

    public Connection open(String uri) throws MalformedURLException, RemoteException {
        return this.open(uri, null);
    }

    public Connection open(String uri, ConnectionProperties properties) throws MalformedURLException, RemoteException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        Connection connection = null;
        if (!uri.startsWith(this._tcp.getScheme())) {
            throw new MalformedURLException("Unrecognised protocol for URI");
        }
        connection = this._tcp.getConnection(uri, properties);
        return connection;
    }

    public void accept(String uri, ConnectionHandler handler) throws MalformedURLException, RemoteException {
        this.accept(uri, handler, null);
    }

    public void accept(String uri, ConnectionHandler handler, ConnectionProperties properties) throws MalformedURLException, RemoteException {
        ConnectionDispatcher dispatcher;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        Object connection = null;
        if (!uri.startsWith(this._tcp.getScheme())) {
            throw new MalformedURLException("Unrecognised protocol for URI");
        }
        ManagedConnectionAcceptor acceptor = this._tcp.getManagedConnectionAcceptor(uri, properties);
        HashMap hashMap = this._dispatchers;
        synchronized (hashMap) {
            dispatcher = (ConnectionDispatcher)this._dispatchers.get(acceptor);
            if (dispatcher == null) {
                acceptor.addAcceptorEventListener(new EventHandler());
                dispatcher = new ConnectionDispatcher(acceptor);
                this._acceptors.put(uri, acceptor);
                this._dispatchers.put(acceptor, dispatcher);
                dispatcher.dispatch();
            }
        }
        dispatcher.accept(uri, handler);
    }

    public void close(String uri) throws MalformedURLException, RemoteException {
        HashMap hashMap = this._dispatchers;
        synchronized (hashMap) {
            ConnectionDispatcher dispatcher;
            ManagedConnectionAcceptor acceptor = (ManagedConnectionAcceptor)this._acceptors.get(uri);
            if (acceptor != null && (dispatcher = (ConnectionDispatcher)this._dispatchers.get(acceptor)) != null) {
                dispatcher.close(uri);
            }
        }
    }

    private void remove(ManagedConnectionAcceptor acceptor) {
        HashMap hashMap = this._dispatchers;
        synchronized (hashMap) {
            this._acceptors.remove(acceptor.getURI());
            ConnectionDispatcher dispatcher = (ConnectionDispatcher)this._dispatchers.remove(acceptor);
            if (dispatcher != null) {
                dispatcher.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EventHandler
    implements AcceptorEventListener {
        private EventHandler() {
        }

        public void closed(ManagedConnectionAcceptor acceptor) {
            Messenger.this.remove(acceptor);
        }

        public void error(ManagedConnectionAcceptor acceptor, Exception exception) {
            Messenger.this.remove(acceptor);
        }
    }
}

