/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.Channel;
import org.exolab.core.messenger.Connection;
import org.exolab.core.messenger.ConnectionEventListener;
import org.exolab.core.messenger.ConnectionHandler;
import org.exolab.core.messenger.ConnectionProperties;
import org.exolab.core.messenger.Context;
import org.exolab.core.messenger.Demultiplexer;
import org.exolab.core.messenger.ManagedConnection;
import org.exolab.core.messenger.ManagedConnectionEventListener;
import org.exolab.core.messenger.MessengerException;
import org.exolab.core.messenger.Multiplexer;
import org.exolab.core.messenger.MultiplexerFactory;
import org.exolab.core.messenger.PacketChannel;
import org.exolab.core.messenger.PacketConnection;
import org.exolab.core.messenger.PacketConnectionAcceptor;
import org.exolab.core.messenger.PacketPool;
import org.exolab.core.messenger.PacketQueue;
import org.exolab.core.threadPool.ThreadPool;

public class ManagedPacketConnection
implements ManagedConnection,
ConnectionEventListener {
    private MultiplexerFactory _factory;
    private Multiplexer _multiplexer;
    private Demultiplexer _demultiplexer;
    private PacketConnection _system;
    private PacketChannel _connectionChannel;
    private PacketChannel _connectionAcceptChannel;
    private PacketChannel _handshakeChannel;
    private HashMap _connections = new HashMap();
    private PacketQueue _queue;
    private ThreadPool _threads;
    private PacketPool _pool;
    private ManagedConnectionEventListener _listener;
    private PacketConnectionAcceptor _acceptor;
    private boolean _closed = false;
    private boolean _invalid = false;
    private int _connectionIdSeed = 1;
    private static final int SYSTEM_CONNECTION_ID = 0;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$messenger$ManagedPacketConnection == null ? (class$org$exolab$core$messenger$ManagedPacketConnection = ManagedPacketConnection.class$("org.exolab.core.messenger.ManagedPacketConnection")) : class$org$exolab$core$messenger$ManagedPacketConnection));
    static /* synthetic */ Class class$org$exolab$core$messenger$ManagedPacketConnection;

    public ManagedPacketConnection(Context context, MultiplexerFactory factory) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        this._queue = new PacketQueue(1024);
        this._threads = context.getThreads();
        this._pool = new PacketPool(1024);
        this._factory = factory;
        this._acceptor = new PacketConnectionAcceptor(this);
    }

    public Connection open(String name, ConnectionProperties properties) throws RemoteException {
        ConnectResponse response;
        PacketChannel channel;
        PacketConnection result = null;
        ConnectRequest request = new ConnectRequest(name);
        ManagedPacketConnection managedPacketConnection = this;
        synchronized (managedPacketConnection) {
            this.ensureOpen();
            channel = this._connectionChannel;
        }
        try {
            response = (ConnectResponse)channel.invoke(request);
        }
        catch (RemoteException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ServerException(exception.getMessage(), exception);
        }
        int connectionId = response.getConnectionId();
        ManagedPacketConnection managedPacketConnection2 = this;
        synchronized (managedPacketConnection2) {
            this.ensureOpen();
            result = new PacketConnection(this, connectionId);
            this._connections.put(new Integer(connectionId), result);
            result.addConnectionEventListener(this);
        }
        return result;
    }

    public synchronized void accept(String name, ConnectionHandler handler) throws RemoteException {
        this.ensureOpen();
        this._acceptor.accept(name, handler);
    }

    public synchronized void close(String name) {
        if (this._acceptor != null) {
            this._acceptor.close(name);
        }
    }

    public void close() throws RemoteException {
        ManagedConnectionEventListener listener;
        ManagedPacketConnection managedPacketConnection = this;
        synchronized (managedPacketConnection) {
            listener = this._listener;
            this.doClose();
        }
        if (listener != null) {
            listener.closed(this);
        }
    }

    public synchronized void setManagedConnectionEventListener(ManagedConnectionEventListener listener) {
        this._listener = listener;
    }

    public void closed(Connection connection) {
        boolean destroy = false;
        ManagedPacketConnection managedPacketConnection = this;
        synchronized (managedPacketConnection) {
            if (!this._closed) {
                int connectionId = ((PacketConnection)connection).getConnectionId();
                this._connections.remove(new Integer(connectionId));
                if (this._connections.size() <= 1) {
                    destroy = true;
                }
            }
        }
        if (destroy) {
            try {
                this.close();
            }
            catch (RemoteException ignore) {
                _log.debug((Object)"Caught exception during close", (Throwable)ignore);
            }
        }
    }

    public void error(Connection connection, Exception exception) {
        _log.error((Object)"Error on connection", (Throwable)exception);
    }

    protected Channel getChannel(int connectionId, int channelId) {
        PacketConnection connection = null;
        ManagedPacketConnection managedPacketConnection = this;
        synchronized (managedPacketConnection) {
            if (!this._closed) {
                connection = (PacketConnection)this._connections.get(new Integer(connectionId));
            }
        }
        return connection != null ? connection.getChannel(channelId) : null;
    }

    protected void initialise() throws RemoteException {
        this._multiplexer = this._factory.createMultiplexer(this);
        this._demultiplexer = this._factory.createDemultiplexer(this);
        this._system = new PacketConnection(this, 0);
        this._connections.put(new Integer(0), this._system);
        this._connectionChannel = this._system.createChannel(0, 1);
        this._connectionAcceptChannel = this._system.createChannel(1, 0);
        this._connectionAcceptChannel.setChannelListener(this._acceptor);
        this._handshakeChannel = this._system.createChannel(4, 4);
        try {
            ManagedPacketConnection managedPacketConnection = this;
            synchronized (managedPacketConnection) {
                this._multiplexer.start();
                this._demultiplexer.start();
            }
            this.handshake(10000L);
        }
        catch (RemoteException exception) {
            this.closeInternal();
            throw new RemoteException("guck", exception);
        }
    }

    protected synchronized void doClose() throws RemoteException {
        if (!this._closed) {
            this._closed = true;
            this.closeInternal();
            this._factory = null;
            if (this._connectionChannel != null) {
                this._connectionChannel.close();
                this._connectionChannel = null;
            }
            if (this._handshakeChannel != null) {
                this._handshakeChannel.close();
                this._handshakeChannel = null;
            }
            if (this._system != null) {
                this._system.close();
                this._system = null;
            }
            if (this._pool != null) {
                this._pool.close();
                this._pool = null;
            }
            this._threads = null;
            this._listener = null;
        }
    }

    protected synchronized PacketQueue getOutputQueue() {
        return this._queue;
    }

    protected synchronized PacketPool getPool() {
        return this._pool;
    }

    protected synchronized ThreadPool getThreadPool() {
        return this._threads;
    }

    protected synchronized PacketConnection createConnection(String name) throws RemoteException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' is null");
        }
        int connectionId = ++this._connectionIdSeed;
        PacketConnection connection = new PacketConnection(this, connectionId);
        this._connections.put(new Integer(connectionId), connection);
        return connection;
    }

    private void handshake(long timeout) throws RemoteException {
        this._handshakeChannel.send(new Handshake());
        Object response = this._handshakeChannel.receive(timeout);
        if (!(response instanceof Handshake)) {
            _log.debug((Object)("Invalid connection protocol: handshake on managed connection received a " + response.getClass().getName()));
            throw new MessengerException("Invalid connection protocol");
        }
    }

    private synchronized void closeInternal() {
        if (this._multiplexer != null) {
            this._multiplexer.close();
            this._multiplexer = null;
        }
        if (this._demultiplexer != null) {
            this._demultiplexer.close();
            this._demultiplexer = null;
        }
        if (this._queue != null) {
            this._queue.close();
            this._queue = null;
        }
    }

    protected synchronized void ensureOpen() throws RemoteException {
        if (this._closed || this._invalid) {
            throw new RemoteException("Connection is closed");
        }
    }

    protected synchronized void streamClosed() {
        _log.debug((Object)"Multiplexer/Demultiplexer terminating");
        ManagedPacketConnection managedPacketConnection = this;
        synchronized (managedPacketConnection) {
            this._invalid = true;
            this.closeInternal();
        }
    }

    protected void errorOnStream(Exception reason) {
        _log.debug((Object)"Multiplexer/Demultiplexer terminating on error", (Throwable)reason);
        ManagedPacketConnection managedPacketConnection = this;
        synchronized (managedPacketConnection) {
            this._invalid = true;
            this.closeInternal();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Handshake
    implements Serializable {
        static final long serialVersionUID = 1L;
    }

    public static final class ConnectResponse
    implements Serializable {
        static final long serialVersionUID = 1L;
        private int _connectionId = -1;

        public ConnectResponse() {
        }

        public ConnectResponse(int connectionId) {
            this._connectionId = connectionId;
        }

        public int getConnectionId() {
            return this._connectionId;
        }
    }

    public static final class ConnectRequest
    implements Serializable {
        static final long serialVersionUID = 1L;
        private String _name;

        public ConnectRequest(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

