/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.util.LinkedList;
import java.util.List;
import org.exolab.core.messenger.Connection;
import org.exolab.core.messenger.ConnectionEventListener;

public class ConnectionEventNotifier {
    private List _listeners = new LinkedList();

    public void addConnectionEventListener(ConnectionEventListener listener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(listener);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    public void closed(Connection connection) {
        Object[] listeners;
        List list = this._listeners;
        synchronized (list) {
            listeners = this._listeners.toArray();
        }
        int i = 0;
        while (i < listeners.length) {
            ConnectionEventListener listener = (ConnectionEventListener)listeners[i];
            listener.closed(connection);
            ++i;
        }
    }

    public void error(Connection connection, Exception exception) {
        Object[] listeners;
        List list = this._listeners;
        synchronized (list) {
            listeners = this._listeners.toArray();
        }
        int i = 0;
        while (i < listeners.length) {
            ConnectionEventListener listener = (ConnectionEventListener)listeners[i];
            listener.error(connection, exception);
            ++i;
        }
    }
}

