/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.messenger.ConnectionHandler;
import org.exolab.core.messenger.ManagedConnection;
import org.exolab.core.messenger.ManagedConnectionAcceptor;
import org.exolab.core.messenger.MessengerException;

class ConnectionDispatcher
implements Runnable {
    private ManagedConnectionAcceptor _acceptor;
    private Thread _thread;
    private boolean _closed = false;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$messenger$ConnectionDispatcher == null ? (class$org$exolab$core$messenger$ConnectionDispatcher = ConnectionDispatcher.class$("org.exolab.core.messenger.ConnectionDispatcher")) : class$org$exolab$core$messenger$ConnectionDispatcher));
    static /* synthetic */ Class class$org$exolab$core$messenger$ConnectionDispatcher;

    public ConnectionDispatcher(ManagedConnectionAcceptor acceptor) {
        if (acceptor == null) {
            throw new IllegalArgumentException("Argument 'acceptor' is null");
        }
        this._acceptor = acceptor;
    }

    public synchronized void dispatch() {
        if (this._thread == null) {
            String name = "ConnectionDispatcher: " + this._acceptor.getURI();
            this._thread = new Thread((Runnable)this, name);
            this._thread.start();
        }
    }

    public synchronized void accept(String uri, ConnectionHandler handler) throws MalformedURLException, RemoteException {
        if (this._closed) {
            throw new MessengerException("Connection dispatcher is closed");
        }
        this._acceptor.accept(uri, handler);
    }

    public synchronized void close(String uri) throws MalformedURLException, RemoteException {
        if (!this._closed) {
            this._acceptor.close(uri);
        }
    }

    public void run() {
        while (!this.closed()) {
            try {
                ManagedConnection connection = this._acceptor.accept();
            }
            catch (RemoteException exception) {
                ConnectionDispatcher connectionDispatcher = this;
                synchronized (connectionDispatcher) {
                    if (!this._closed) {
                        _log.debug((Object)exception, (Throwable)exception);
                        this._closed = true;
                    }
                }
            }
        }
        this._acceptor = null;
    }

    public synchronized void close() {
        if (!this._closed) {
            this._closed = true;
            try {
                this._acceptor.close();
            }
            catch (RemoteException exception) {
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
    }

    public synchronized boolean closed() {
        return this._closed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

