/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.UnknownHostException;
import org.exolab.core.ipc.IpcIfc;

public class TcpService
implements IpcIfc {
    private Socket sock_;
    private DataInputStream input_ = null;
    private DataOutputStream output_ = null;
    public static final int TIMEOUT = 10000;
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 3030;

    public TcpService() throws UnknownHostException, IOException {
        this(LOCAL_HOST, 3030);
    }

    public TcpService(String host, int port) throws UnknownHostException, IOException {
        this(new Socket(host, port));
        try {
            this.sock_.setSoTimeout(10000);
            this.sock_.setSoLinger(true, 30);
        }
        catch (SocketException err) {
            System.err.println("Failed to set socket options: " + err.getMessage());
        }
    }

    public TcpService(Socket sock) throws IOException {
        this.sock_ = sock;
        this.input_ = new DataInputStream(this.sock_.getInputStream());
        this.output_ = new DataOutputStream(this.sock_.getOutputStream());
    }

    public Socket getSocket() {
        return this.sock_;
    }

    public void close() throws IOException {
        this.sock_.close();
    }

    public void send(Serializable ob) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(ob);
        byte[] buffer = bytes.toByteArray();
        out.close();
        this.output_.writeInt(buffer.length);
        this.output_.write(buffer);
    }

    public Object receive() throws IOException, ClassNotFoundException {
        Object ob = null;
        int n = this.input_.readInt();
        byte[] buffer = new byte[n];
        this.input_.readFully(buffer);
        ByteArrayInputStream bytes = new ByteArrayInputStream(buffer);
        ObjectInputStream in = new ObjectInputStream(bytes);
        ob = in.readObject();
        in.close();
        return ob;
    }

    public String toString() {
        return String.valueOf(this.sock_.getPort());
    }
}

