/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.ipc.IpcServerIfc;
import org.exolab.core.ipc.Notifier;
import org.exolab.core.ipc.NotifierIfc;
import org.exolab.core.ipc.TcpService;

public class TcpServerService
implements IpcServerIfc {
    private ServerSocket _server;
    private HashMap _connections = new HashMap(50);
    private boolean _active = true;
    private NotifierIfc _notifier = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$ipc$TcpServerService == null ? (class$org$exolab$core$ipc$TcpServerService = TcpServerService.class$("org.exolab.core.ipc.TcpServerService")) : class$org$exolab$core$ipc$TcpServerService));
    static /* synthetic */ Class class$org$exolab$core$ipc$TcpServerService;

    public TcpServerService(NotifierIfc notifier) throws IOException {
        this(0, notifier);
    }

    public TcpServerService(int port, NotifierIfc notifier) throws IOException {
        this(null, port, notifier);
    }

    public TcpServerService(InetAddress address, int port, NotifierIfc notifier) throws IOException {
        this._notifier = notifier;
        this._server = new ServerSocket(port, 50, address);
    }

    public void start() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Server is ready, on port " + this._server.getLocalPort()));
        }
        while (this._active) {
            try {
                Socket s = this._server.accept();
                new Notifier(this._notifier, new TcpService(s), this._connections);
            }
            catch (IOException exception) {
                _log.debug((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void shutdownAll() throws IOException {
        Object[] connections = this._connections.values().toArray();
        int i = 0;
        int j = this._connections.size();
        while (i < j) {
            ((Notifier)connections[i]).stop();
            ++i;
        }
        this._connections.clear();
        this._active = false;
        this._server.close();
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    public String getHost() {
        String host = "127.0.0.1";
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException exception) {
            _log.debug((Object)"Failed to get IP address for this host");
        }
        return host;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

