/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.ipc;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.core.ipc.NotifierIfc;

public class Notifier {
    NotifierIfc client_;
    IpcIfc ipc_;
    boolean stopRequested_ = false;
    Thread thread_;
    HashMap pool_;
    String id_;

    public Notifier(NotifierIfc client, IpcIfc ipc, HashMap pool) {
        this.client_ = client;
        this.ipc_ = ipc;
        this.pool_ = pool;
        this.id_ = ipc.toString();
        Runnable r = new Runnable(){

            public void run() {
                Notifier.this.start();
            }
        };
        this.thread_ = new Thread(r);
        this.thread_.start();
        HashMap hashMap = this.pool_;
        synchronized (hashMap) {
            this.pool_.put(this.thread_.getName(), this);
        }
    }

    private void start() {
        while (!this.stopRequested_) {
            try {
                Object ob = this.ipc_.receive();
                Serializable returnValue = this.client_.notify(ob, this.id_);
                if (returnValue == null) continue;
                this.ipc_.send(returnValue);
            }
            catch (IOException err) {
                this.stopRequested_ = true;
            }
            catch (ClassNotFoundException err) {
                System.err.println("Unknown Class Ignoring\n" + err);
            }
            catch (Exception err) {
                System.err.println("Shutdown request");
            }
        }
        this.client_.disconnection(this.id_);
        HashMap hashMap = this.pool_;
        synchronized (hashMap) {
            if (this.ipc_ != null) {
                try {
                    this.ipc_.close();
                }
                catch (IOException err) {
                    // empty catch block
                }
                this.ipc_ = null;
            }
            this.pool_.remove(this.thread_.getName());
        }
    }

    public void stop() {
        try {
            this.stopRequested_ = true;
            this.thread_.interrupt();
            this.ipc_.close();
            this.ipc_ = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

