/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.exolab.core.ipc.IpcIfc;

public class HttpClient
implements IpcIfc {
    private String _label;
    private Object _receivedData = null;
    private URL _server = null;

    public HttpClient(String url, String label) throws MalformedURLException {
        this._label = label;
        this._server = new URL(url);
    }

    public void close() throws IOException {
        this._receivedData = null;
        this._label = null;
    }

    public void send(Serializable ob, String host, String port) throws IOException {
        this._receivedData = null;
        this.sendMessage(ob, true, true, host, port);
    }

    public void send(Serializable ob) throws IOException {
        this._receivedData = null;
        this.sendMessage(ob, true, true, null, null);
    }

    public void sendWithoutResponse(Serializable ob) throws IOException {
        this._receivedData = null;
        this.sendMessage(ob, true, false, null, null);
    }

    public void sendWithoutResponse(Serializable ob, String host, String port) throws IOException {
        this._receivedData = null;
        this.sendMessage(ob, true, false, host, port);
    }

    public Object receive() {
        return this._receivedData;
    }

    public URL getURL() {
        return this._server;
    }

    public String toString() {
        return "HttpClient - " + this._label;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(Object data, boolean op, boolean expectResponse, String host, String port) throws IOException {
        ObjectInputStream response = null;
        Object result = null;
        try {
            try {
                URLConnection con = this._server.openConnection();
                con.setDoOutput(op);
                con.setUseCaches(false);
                con.setRequestProperty("Content-Type", "application/octet-stream");
                if (expectResponse) {
                    con.setRequestProperty("jms-response", "yes");
                }
                if (host != null) {
                    con.setRequestProperty("jms-host", host);
                }
                if (port != null) {
                    con.setRequestProperty("jms-port", port);
                }
                ObjectOutputStream request = new ObjectOutputStream(new BufferedOutputStream(con.getOutputStream()));
                request.writeObject(data);
                request.flush();
                request.close();
                response = new ObjectInputStream(new BufferedInputStream(con.getInputStream()));
                if (expectResponse) {
                    this._receivedData = response.readObject();
                }
            }
            catch (ClassNotFoundException err) {
                System.err.println(err);
                throw new IOException(err.getMessage());
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (response == null) throw throwable;
                response.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        if (response == null) return;
        response.close();
        return;
    }
}

