/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.foundation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.core.foundation.CacheEntry;
import org.exolab.core.foundation.LruCacheEnumeration;

public class LruObjectCache {
    private int maxSize_ = 0;
    private Hashtable keyMap_ = null;
    private long hits_ = 0L;
    private long getRequests_ = 0L;
    private CacheEntry head_ = null;
    private CacheEntry tail_ = null;

    public LruObjectCache(int size) {
        this.maxSize_ = size;
        this.hits_ = 0L;
        this.getRequests_ = 0L;
        this.keyMap_ = new Hashtable(size);
        this.head_ = null;
        this.tail_ = null;
    }

    public synchronized void insert(Object key, Object object) {
        this.touchCacheEntry(key, object);
    }

    public synchronized void remove(Object key) {
        this.removeFromCache(key);
    }

    public synchronized Object get(Object key) {
        CacheEntry value = (CacheEntry)this.keyMap_.get(key);
        if (value != null) {
            this.touchCacheEntry(key, value.value_);
        }
        return value == null ? null : value.value_;
    }

    public synchronized void clear() {
        CacheEntry entry = this.head_;
        while (entry != null) {
            CacheEntry temp = entry.next_;
            entry.prev_ = null;
            entry.next_ = null;
            entry.key_ = null;
            entry.value_ = null;
            entry = temp;
        }
        this.keyMap_.clear();
        this.head_ = null;
        this.tail_ = null;
        this.getRequests_ = 0L;
        this.hits_ = 0L;
    }

    public double hitMissRatio() {
        return this.hits_ / this.getRequests_;
    }

    public int getUsedSlots() {
        return this.keyMap_.size();
    }

    public int getFreeSlots() {
        return this.maxSize_ - this.keyMap_.size();
    }

    public Enumeration elements() {
        return new LruCacheEnumeration(this.tail_);
    }

    protected void touchCacheEntry(Object key, Object object) {
        if (key != null && object != null) {
            ++this.getRequests_;
            CacheEntry entry = (CacheEntry)this.keyMap_.get(key);
            if (entry == null) {
                if (this.keyMap_.size() < this.maxSize_) {
                    entry = new CacheEntry(key, object);
                } else {
                    entry = this.head_;
                    this.head_ = entry.prev_;
                    this.head_.next_ = null;
                    this.keyMap_.remove(entry.key_);
                    entry.value_ = object;
                    entry.key_ = key;
                    entry.prev_ = null;
                    entry.next_ = null;
                }
            } else {
                this.removeFromCache(entry);
                entry.value_ = object;
                ++this.hits_;
            }
            if (this.tail_ != null) {
                this.tail_.prev_ = entry;
            }
            entry.next_ = this.tail_;
            entry.prev_ = null;
            this.tail_ = entry;
            if (this.head_ == null) {
                this.head_ = this.tail_;
            }
            this.keyMap_.put(key, entry);
        }
    }

    protected CacheEntry removeFromCache(CacheEntry entry) {
        if (entry.prev_ != null) {
            entry.prev_.next_ = entry.next_;
        } else {
            this.tail_ = entry.next_;
        }
        if (entry.next_ != null) {
            entry.next_.prev_ = entry.prev_;
        } else {
            this.head_ = entry.prev_;
        }
        this.keyMap_.remove(entry.key_);
        return entry;
    }

    protected CacheEntry removeFromCache(Object key) {
        CacheEntry entry = null;
        if (key != null && (entry = (CacheEntry)this.keyMap_.get(key)) != null) {
            this.removeFromCache(entry);
            entry.key_ = null;
            entry.value_ = null;
            entry.prev_ = null;
            entry.next_ = null;
        }
        return entry;
    }
}

