/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.foundation;

import org.exolab.core.foundation.LockNotGrantedException;
import org.exolab.core.foundation.ObjectDeletedWaitingForLockException;
import org.exolab.core.foundation.PersistentCapableIfc;
import org.exolab.core.foundation.TransactionContext;
import org.exolab.core.util.Messages;

public final class Lock {
    private PersistentCapableIfc _object;
    private TransactionContext _lock;
    private int _lockCount;
    private LinkedTx _waiting;

    public Lock(PersistentCapableIfc obj) {
        this._object = obj;
    }

    public boolean hasLock(TransactionContext tx) {
        return this._lock == tx;
    }

    public PersistentCapableIfc getObject() {
        return this._object;
    }

    public synchronized PersistentCapableIfc acquire(TransactionContext tx, int timeout) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        if (this._lock == tx) {
            ++this._lockCount;
        } else if (this._lock == null) {
            this._lock = tx;
            ++this._lockCount;
        } else {
            if (timeout == 0) {
                throw new LockNotGrantedException("container.lockTimeout");
            }
            try {
                tx.setWaitOnLock(this);
                this.detectDeadlock(tx);
                this._waiting = new LinkedTx(tx, this._waiting);
                long clock = System.currentTimeMillis();
                try {
                    this.wait(timeout * 1000);
                }
                catch (InterruptedException except) {
                    System.err.println("SLEEP HAS BEEN INTERRUPTED");
                    throw new LockNotGrantedException("container.lockTimeout");
                }
                if (this._object == null) {
                    throw new ObjectDeletedWaitingForLockException();
                }
                if ((timeout = (int)((long)timeout - (System.currentTimeMillis() - clock))) < 0) {
                    timeout = 0;
                }
                this.removeWaiting(tx);
                PersistentCapableIfc persistentCapableIfc = this.acquire(tx, timeout);
                Object var7_6 = null;
                this.removeWaiting(tx);
                return persistentCapableIfc;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.removeWaiting(tx);
                throw throwable;
            }
        }
        return this._object;
    }

    public synchronized void release(TransactionContext tx) {
        block5: {
            try {
                tx.setWaitOnLock(null);
                if (this._lock == tx) {
                    --this._lockCount;
                    if (this._lockCount == 0) {
                        this._lock = null;
                        if (this._waiting != null) {
                            this.notify();
                        }
                    }
                    break block5;
                }
                throw new IllegalStateException(Messages.message("container.notOwnerLock"));
            }
            catch (Throwable death) {
                this.release(tx);
            }
        }
    }

    public synchronized boolean anyTxWaiting() {
        boolean result = true;
        if (this._lockCount == 0) {
            result = false;
        }
        return result;
    }

    public synchronized void delete(TransactionContext tx) {
        if (tx != this._lock) {
            throw new IllegalStateException(Messages.message("container.notOwnerLock"));
        }
        try {
            this._object = null;
            this._lock = null;
            this._lockCount = 0;
            this.notifyAll();
        }
        catch (Throwable death) {
            this.release(tx);
        }
    }

    private void detectDeadlock(TransactionContext waitingTx) throws LockNotGrantedException {
        Lock waitOn = this._lock.getWaitOnLock();
        if (waitOn != null) {
            if (waitOn._lock == waitingTx) {
                throw new LockNotGrantedException("container.deadlock");
            }
            waitOn.detectDeadlock(waitingTx);
        }
    }

    private void removeWaiting(TransactionContext tx) {
        block5: {
            try {
                tx.setWaitOnLock(null);
                if (this._waiting == null) break block5;
                if (this._waiting.tx == tx) {
                    this._waiting = this._waiting.next;
                    break block5;
                }
                LinkedTx wait = this._waiting;
                while (wait.next != null) {
                    if (wait.next.tx == tx) {
                        wait.next = wait.next.next;
                        break;
                    }
                    wait = wait.next;
                }
            }
            catch (Throwable death) {
                this.removeWaiting(tx);
            }
        }
    }

    static class LinkedTx {
        TransactionContext tx;
        LinkedTx next;

        LinkedTx(TransactionContext tx, LinkedTx next) {
            this.tx = tx;
            this.next = next;
        }
    }
}

