/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.database.recman;

import com.cdegroot.db.recman.RecordManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.database.recman.LockManager;
import org.exolab.core.database.recman.PMDRootTable;
import org.exolab.core.foundation.DatabaseIOException;
import org.exolab.core.foundation.DatabaseIfc;
import org.exolab.core.foundation.FailedToCreateDatabaseException;
import org.exolab.core.foundation.FailedToOpenDatabaseException;
import org.exolab.core.foundation.LruObjectCache;
import org.exolab.core.foundation.NoAvailableRootException;
import org.exolab.core.foundation.ObjectNameExistsException;
import org.exolab.core.foundation.ObjectNameNotFoundException;
import org.exolab.core.foundation.PersistentCapableIfc;

public class PageManagedDatabase
implements DatabaseIfc {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$database$recman$PageManagedDatabase == null ? (class$org$exolab$core$database$recman$PageManagedDatabase = PageManagedDatabase.class$("org.exolab.core.database.recman.PageManagedDatabase")) : class$org$exolab$core$database$recman$PageManagedDatabase));
    private RecordManager db_ = null;
    private boolean opened_ = false;
    private int lastAllocatedRoot_ = 0;
    private PMDRootTable namedRootTable_ = null;
    private String name_ = null;
    private LruObjectCache objectCache_ = null;
    private static final int ROOT_NAMES_INDEX = 0;
    private static final int UNASSIGNED = -1;
    static /* synthetic */ Class class$org$exolab$core$database$recman$PageManagedDatabase;

    public PageManagedDatabase(String name) throws FailedToCreateDatabaseException {
        try {
            LockManager.getInstance().acquire(name);
            this.name_ = name;
            this.db_ = new RecordManager(name);
            this.opened_ = true;
            this.getNamedRootTable();
        }
        catch (IOException exception) {
            throw new FailedToCreateDatabaseException("Failed to create database " + name + " b/c" + exception);
        }
    }

    public void open() throws FailedToOpenDatabaseException {
        if (!this.opened_) {
            throw new FailedToOpenDatabaseException("Failed to open db " + this.name_);
        }
    }

    public void close() {
        try {
            this.db_.close();
            this.opened_ = false;
            LockManager.getInstance().release(this.name_);
        }
        catch (IOException exception) {
            _log.error((Object)"Failed to close db", (Throwable)exception);
        }
    }

    public boolean isOpen() {
        return this.opened_;
    }

    public Enumeration getRootNames() {
        int root_count = this.db_.getRootCount();
        Vector<String> roots = new Vector<String>();
        PMDRootTable pMDRootTable = this.namedRootTable_;
        synchronized (pMDRootTable) {
            Enumeration names = this.namedRootTable_.names();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                roots.addElement(name);
            }
        }
        return roots.elements();
    }

    public void bind(String name, PersistentCapableIfc object) throws ObjectNameExistsException, DatabaseIOException {
        this.setRootObject(name, object);
    }

    public void unbind(String name) throws ObjectNameNotFoundException, DatabaseIOException {
        this.removeRootObject(name);
    }

    public PersistentCapableIfc lookup(String name) {
        return (PersistentCapableIfc)this.getRootObject(name);
    }

    public Object getRootObject(String name) {
        Object instance = null;
        if (this.namedRootTable_.containsName(name)) {
            instance = this.namedRootTable_.get(name);
        }
        return instance;
    }

    public void setRootObject(String name, Object object) throws ObjectNameExistsException, DatabaseIOException {
        try {
            PMDRootTable pMDRootTable = this.namedRootTable_;
            synchronized (pMDRootTable) {
                if (this.getRootObject(name) != null) {
                    throw new ObjectNameExistsException("The root named " + name + " already exists");
                }
                _log.debug((Object)("PMD RootObject " + object));
                this.namedRootTable_.put(name, object);
                this.updateNamedRootTable();
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("Error in bind for name " + name + " " + exception);
        }
    }

    public void removeRootObject(String name) throws ObjectNameNotFoundException, DatabaseIOException {
        try {
            PMDRootTable pMDRootTable = this.namedRootTable_;
            synchronized (pMDRootTable) {
                if (this.getRootObject(name) == null) {
                    throw new ObjectNameNotFoundException("Failed to unbind " + name);
                }
                this.namedRootTable_.remove(name);
                this.updateNamedRootTable();
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("Error in unbind for name " + name + " " + exception);
        }
    }

    public boolean isBound(String name) {
        return this.lookup(name) != null;
    }

    public void deleteObject(long id) throws DatabaseIOException {
        try {
            this.db_.delete(id);
            if (this.objectCache_ != null) {
                this.objectCache_.remove(new Long(id));
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("Failed to delete object with id " + id + ". Reason : " + exception.toString());
        }
    }

    public long allocateObject(int size) throws DatabaseIOException {
        return this.insertBytes(new byte[size]);
    }

    public void insert(PersistentCapableIfc object) throws DatabaseIOException {
        long id = this.insertObject(object);
        object.getObjectId().setId(id);
        this.updateObject(id, object);
    }

    public void delete(PersistentCapableIfc object) throws DatabaseIOException {
        this.deleteObject(object.getObjectId().getId());
    }

    public void update(PersistentCapableIfc object) throws DatabaseIOException {
        this.updateObject(object.getObjectId().getId(), object);
    }

    public long insertBoolean(boolean value) throws DatabaseIOException {
        return this.writeBoolean(-1L, value);
    }

    public long insertByte(byte value) throws DatabaseIOException {
        return this.writeByte(-1L, value);
    }

    public long insertShort(short value) throws DatabaseIOException {
        long result = 0L;
        try {
            result = this.writeShort(-1L, value);
        }
        catch (Exception exception) {
            throw new DatabaseIOException("insertShort failed - " + exception.toString());
        }
        return result;
    }

    public long insertChar(char value) throws DatabaseIOException {
        return this.writeChar(-1L, value);
    }

    public long insertInt(int value) throws DatabaseIOException {
        return this.writeInt(-1L, value);
    }

    public long insertLong(long value) throws DatabaseIOException {
        return this.writeLong(-1L, value);
    }

    public long insertFloat(float value) throws DatabaseIOException {
        return this.writeFloat(-1L, value);
    }

    public long insertDouble(double value) throws DatabaseIOException {
        return this.writeDouble(-1L, value);
    }

    public long insertBytes(byte[] value) throws DatabaseIOException {
        return this.writeBytes(-1L, value);
    }

    public long insertString(String value) throws DatabaseIOException {
        return this.writeString(-1L, value);
    }

    public long insertObject(Object value) throws DatabaseIOException {
        return this.writeObject(-1L, value);
    }

    public long updateBoolean(long id, boolean value) throws DatabaseIOException {
        return this.writeBoolean(id, value);
    }

    public long updateByte(long id, byte value) throws DatabaseIOException {
        long result = 0L;
        try {
            result = this.writeByte(id, value);
        }
        catch (Exception exception) {
            throw new DatabaseIOException("updateByte failed - " + exception.toString());
        }
        return result;
    }

    public long updateShort(long id, short value) throws DatabaseIOException {
        return this.writeShort(id, value);
    }

    public long updateChar(long id, char value) throws DatabaseIOException {
        return this.writeChar(id, value);
    }

    public long updateInt(long id, int value) throws DatabaseIOException {
        return this.writeInt(id, value);
    }

    public long updateLong(long id, long value) throws DatabaseIOException {
        return this.writeLong(id, value);
    }

    public long updateFloat(long id, float value) throws DatabaseIOException {
        return this.writeFloat(id, value);
    }

    public long updateDouble(long id, double value) throws DatabaseIOException {
        return this.writeDouble(id, value);
    }

    public long updateBytes(long id, byte[] value) throws DatabaseIOException {
        return this.writeBytes(id, value);
    }

    public long updateString(long id, String value) throws DatabaseIOException {
        return this.writeString(id, value);
    }

    public long updateObject(long id, Object value) throws DatabaseIOException {
        return this.writeObject(id, value);
    }

    public boolean readBoolean(long id) throws DatabaseIOException {
        boolean value = false;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readBoolean();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readBoolean failed for id " + id + " with " + exception);
        }
        return value;
    }

    public byte readByte(long id) throws DatabaseIOException {
        byte value = 0;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readByte();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readByte failed for id " + id + " with " + exception);
        }
        return value;
    }

    public short readShort(long id) throws DatabaseIOException {
        short value = 0;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readShort();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readShort failed for id " + id + " with " + exception);
        }
        return value;
    }

    public char readChar(long id) throws DatabaseIOException {
        char value = '\u0000';
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readChar();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readChar failed for id " + id + " with " + exception);
        }
        return value;
    }

    public int readInt(long id) throws DatabaseIOException {
        int value = 0;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readInt();
        }
        catch (IOException exception) {
            _log.error((Object)exception);
            throw new DatabaseIOException("readInt failed for id " + id + " with " + exception);
        }
        return value;
    }

    public long readLong(long id) throws DatabaseIOException {
        long value = 0L;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readLong();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readLong failed for id " + id + " with " + exception);
        }
        return value;
    }

    public float readFloat(long id) throws DatabaseIOException {
        float value = 0.0f;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readFloat();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readFloat failed for id " + id + " with " + exception);
        }
        return value;
    }

    public double readDouble(long id) throws DatabaseIOException {
        double value = 0.0;
        try {
            byte[] in_buf = this.db_.fetch(id);
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
            DataInputStream in_stream = new DataInputStream(byte_stream);
            value = in_stream.readDouble();
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readDouble failed for id " + id + " with " + exception);
        }
        return value;
    }

    public byte[] readBytes(long id) throws DatabaseIOException {
        byte[] value = null;
        try {
            value = this.db_.fetch(id);
        }
        catch (IOException exception) {
            throw new DatabaseIOException("readByte failed for id " + id + " with " + exception);
        }
        return value;
    }

    public String readString(long id) throws DatabaseIOException {
        return (String)this.readObject(id);
    }

    public Object readObject(long id) throws DatabaseIOException {
        Object value = null;
        try {
            if (this.objectCache_ != null) {
                value = this.objectCache_.get(new Long(id));
            }
            if (value == null) {
                byte[] in_buf = this.db_.fetch(id);
                ByteArrayInputStream byte_stream = new ByteArrayInputStream(in_buf);
                ObjectInputStream in_stream = new ObjectInputStream(byte_stream);
                value = in_stream.readObject();
                if (this.objectCache_ != null && value != null) {
                    this.objectCache_.insert(new Long(id), value);
                }
            }
        }
        catch (Exception exception) {
            throw new DatabaseIOException("readObject failed for id " + id + " with " + exception);
        }
        return value;
    }

    public void setObjectCacheSize(int size) {
        if (size == 0) {
            this.objectCache_ = null;
        } else if (size < 0) {
            _log.warn((Object)"Can't specify a cache size less than 0");
        } else {
            this.objectCache_ = new LruObjectCache(size);
        }
    }

    protected long writeBoolean(long id, boolean value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeBoolean(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeBoolean failed " + exception.toString());
        }
        return id;
    }

    protected long writeByte(long id, byte value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeByte(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeByte failed " + exception.toString());
        }
        return id;
    }

    protected long writeShort(long id, short value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeShort(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeShort failed " + exception.toString());
        }
        return id;
    }

    protected long writeChar(long id, char value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeChar(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeChar failed " + exception.toString());
        }
        return id;
    }

    protected long writeInt(long id, int value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeInt(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeInt failed " + exception.toString());
        }
        return id;
    }

    protected long writeLong(long id, long value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeLong(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeLong failed " + exception.toString());
        }
        return id;
    }

    protected long writeFloat(long id, float value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeFloat(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeFloat failed " + exception.toString());
        }
        return id;
    }

    protected long writeDouble(long id, double value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
            DataOutputStream out_stream = new DataOutputStream(out_buf);
            out_stream.writeDouble(value);
            if (id == -1L) {
                id = this.db_.insert(out_buf.toByteArray());
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
        }
        catch (Exception exception) {
            throw new DatabaseIOException("writeDouble failed " + exception.toString());
        }
        return id;
    }

    protected long writeBytes(long id, byte[] value) throws DatabaseIOException {
        try {
            if (id == -1L) {
                id = this.db_.insert(value);
            } else {
                this.db_.update(id, value);
            }
        }
        catch (Exception exception) {
            throw new DatabaseIOException("writeBytes failed " + exception.toString());
        }
        return id;
    }

    protected long writeString(long id, String value) throws DatabaseIOException {
        return this.writeObject(id, value);
    }

    protected long writeObject(long id, Object value) throws DatabaseIOException {
        try {
            ByteArrayOutputStream out_buf = new ByteArrayOutputStream(1024);
            ObjectOutputStream out_stream = new ObjectOutputStream(out_buf);
            out_stream.writeObject(value);
            if (id == -1L) {
                if (value instanceof PersistentCapableIfc) {
                    int min_size = ((PersistentCapableIfc)value).getMinimumObjectSize();
                    if (min_size > out_buf.size()) {
                        id = this.db_.insert(new byte[min_size]);
                        this.db_.update(id, out_buf.toByteArray());
                    } else {
                        id = this.db_.insert(out_buf.toByteArray());
                    }
                } else {
                    id = this.db_.insert(out_buf.toByteArray());
                }
            } else {
                this.db_.update(id, out_buf.toByteArray());
            }
            if (this.objectCache_ != null) {
                this.objectCache_.insert(new Long(id), value);
            }
        }
        catch (IOException exception) {
            throw new DatabaseIOException("writeObject failed " + exception.toString());
        }
        return id;
    }

    protected int getFirstFreeRootSlot() throws NoAvailableRootException, IOException {
        int start = this.lastAllocatedRoot_ + 1;
        int root_count = this.db_.getRootCount();
        if (start >= root_count) {
            start = 0;
        }
        while (start != this.lastAllocatedRoot_) {
            if (this.db_.getRoot(start) == 0L) break;
            if (++start < root_count) continue;
            start = 0;
        }
        if (start == this.lastAllocatedRoot_) {
            throw new NoAvailableRootException("All root slots are in use.");
        }
        this.lastAllocatedRoot_ = start;
        return start;
    }

    protected void setNamedRootTable(PMDRootTable table) throws IOException, DatabaseIOException {
        this.namedRootTable_ = table;
        this.updateNamedRootTable();
    }

    protected PMDRootTable getNamedRootTable() {
        try {
            long rec_id = this.db_.getRoot(0);
            if (rec_id == 0L) {
                this.namedRootTable_ = new PMDRootTable();
                rec_id = this.insertObject(this.namedRootTable_);
                this.namedRootTable_.setId(rec_id);
                this.updateObject(rec_id, this.namedRootTable_);
                this.db_.setRoot(0, rec_id);
            } else if (this.namedRootTable_ == null) {
                this.namedRootTable_ = (PMDRootTable)this.readObject(rec_id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.namedRootTable_;
    }

    protected void updateNamedRootTable() throws IOException, DatabaseIOException {
        long rec_id = this.db_.getRoot(0);
        if (rec_id != 0L) {
            this.updateObject(rec_id, this.namedRootTable_);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("PageManagedDatabase ");
        buf.append("db _ = ");
        buf.append(this.db_.toString());
        buf.append(" opened_ = ");
        buf.append(this.opened_);
        buf.append(" lastAllocatedRoot_ ");
        buf.append(this.lastAllocatedRoot_);
        buf.append(" namedRootTable_ ");
        buf.append(this.namedRootTable_.toString());
        buf.append(" name_ ");
        buf.append(this.name_);
        return buf.toString();
    }

    void commit() throws IOException {
    }

    void rollback() throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

