/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.database.recman;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.database.recman.PMDRootTable;
import org.exolab.core.database.recman.PageManagedDatabase;
import org.exolab.core.foundation.DatabaseIOException;
import org.exolab.core.foundation.DatabaseIfc;
import org.exolab.core.foundation.FailedToAcquireLockException;
import org.exolab.core.foundation.FailedToCreateLockException;
import org.exolab.core.foundation.Lock;
import org.exolab.core.foundation.ObjectId;
import org.exolab.core.foundation.ObjectNameExistsException;
import org.exolab.core.foundation.ObjectNameNotFoundException;
import org.exolab.core.foundation.PersistentCapableIfc;
import org.exolab.core.foundation.TransactionContext;

class PMDTransactionCache
extends TransactionContext {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$database$recman$PMDTransactionCache == null ? (class$org$exolab$core$database$recman$PMDTransactionCache = PMDTransactionCache.class$("org.exolab.core.database.recman.PMDTransactionCache")) : class$org$exolab$core$database$recman$PMDTransactionCache));
    private transient PageManagedDatabase database_ = null;
    private transient Hashtable objectTranLog_ = new Hashtable();
    private transient Hashtable locallyAccessedObjects_ = new Hashtable();
    private transient Hashtable locallyDeletedObjects_ = new Hashtable();
    private transient Vector sessionLocks_ = new Vector();
    private transient PMDRootTable rootTable_ = null;
    private transient boolean modifiedRootTable_ = false;
    private static transient Hashtable locks__ = new Hashtable();
    static /* synthetic */ Class class$org$exolab$core$database$recman$PMDTransactionCache;

    PMDTransactionCache(PageManagedDatabase database) {
        this.database_ = database;
    }

    DatabaseIfc getDatabase() {
        return this.database_;
    }

    boolean containsRoot(String name) throws DatabaseIOException {
        try {
            return this.lookup(name) != null;
        }
        catch (Exception exception) {
            throw new DatabaseIOException("containsRoot failed " + exception);
        }
    }

    Enumeration getRootNames() {
        Enumeration names = null;
        try {
            names = this.database_.getRootNames();
        }
        catch (Exception exception) {
            _log.error((Object)("getRootNames failed with  " + exception));
        }
        return names;
    }

    void createRoot(String name, PersistentCapableIfc object) throws ObjectNameExistsException, DatabaseIOException {
        try {
            this.acquireRootLock();
            PMDRootTable table = this.getNamedRootTable();
            if (table.get(name) != null) {
                throw new ObjectNameExistsException(name + " is already bound to an object in the database");
            }
            if (object.getObjectId().getId() == 0L) {
                this.createObject(object);
            }
            table.put(name, object.getObjectId());
            this.modifiedRootTable_ = true;
            this.objectTranLog_.put(table.getObjectId(), new TranLogEntry(3, table));
        }
        catch (Exception exception) {
            throw new DatabaseIOException("Can't acquire lock to root object");
        }
    }

    void deleteRoot(String name) throws ObjectNameNotFoundException, DatabaseIOException {
        try {
            this.acquireRootLock();
            PMDRootTable table = this.getNamedRootTable();
            if (table.get(name) == null) {
                throw new ObjectNameNotFoundException(name + " is not bound to an object in the database");
            }
            table.remove(name);
            this.modifiedRootTable_ = true;
            this.objectTranLog_.put(table.getObjectId(), new TranLogEntry(3, table));
        }
        catch (Exception exception) {
            throw new DatabaseIOException("Exception in deleteRoot " + exception);
        }
    }

    PersistentCapableIfc lookup(String name) throws DatabaseIOException {
        PersistentCapableIfc result;
        block3: {
            result = null;
            try {
                ObjectId oid = (ObjectId)this.getNamedRootTable().get(name);
                if (oid == null || (result = (PersistentCapableIfc)this.locallyAccessedObjects_.get(oid)) != null) break block3;
                result = (PersistentCapableIfc)this.database_.readObject(oid.getId());
                if (result != null) {
                    this.locallyAccessedObjects_.put(oid, result);
                    break block3;
                }
                throw new DatabaseIOException("Could not find the root object " + name);
            }
            catch (Exception exception) {
                throw new DatabaseIOException("lookup failed " + exception);
            }
        }
        return result;
    }

    void createObject(PersistentCapableIfc object) throws DatabaseIOException {
        if (object != null) {
            try {
                this.database_.insert(object);
                this.acquireObjectLock(object, 10);
                this.objectTranLog_.put(object.getObjectId(), new TranLogEntry(1, object));
                this.locallyAccessedObjects_.put(object.getObjectId(), object);
            }
            catch (FailedToAcquireLockException exception) {
                throw new DatabaseIOException("Failed to acquire lock on " + object.getObjectId());
            }
            catch (FailedToCreateLockException exception) {
                throw new DatabaseIOException("Failed to create lock on " + object.getObjectId());
            }
        } else {
            throw new DatabaseIOException("Specified object is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void deleteObject(PersistentCapableIfc object) throws DatabaseIOException {
        if (object == null || object.getObjectId().getId() <= 0L) throw new DatabaseIOException("Failed to delete null or malformed object");
        if (this.locallyAccessedObjects_.get(object.getObjectId()) != null) {
            this.locallyAccessedObjects_.remove(object.getObjectId());
            this.locallyDeletedObjects_.put(object.getObjectId(), object);
            this.objectTranLog_.put(object.getObjectId(), new TranLogEntry(2, object));
            return;
        }
        if (this.database_.readObject(object.getObjectId().getId()) == null) throw new DatabaseIOException("Failed to delete object " + object.getObjectId());
        try {
            this.acquireObjectLock(object, 10);
            this.locallyDeletedObjects_.put(object.getObjectId(), object);
            this.objectTranLog_.put(object.getObjectId(), new TranLogEntry(2, object));
            return;
        }
        catch (Exception exception) {
            throw new DatabaseIOException("deleteObject failed on " + object.getObjectId() + " - failed to acquire lock");
        }
    }

    void updateObject(PersistentCapableIfc object) throws DatabaseIOException {
        if (object != null) {
            if (this.locallyDeletedObjects_.get(object.getObjectId()) != null) {
                throw new DatabaseIOException("Cannot update a deleted object " + object.getObjectId());
            }
            if (this.locallyAccessedObjects_.containsKey(object.getObjectId())) {
                this.locallyAccessedObjects_.put(object.getObjectId(), object);
                this.objectTranLog_.put(object.getObjectId(), new TranLogEntry(3, object));
            } else {
                try {
                    this.acquireObjectLock(object, 10);
                    this.objectTranLog_.put(object.getObjectId(), new TranLogEntry(3, object));
                }
                catch (Exception exception) {
                    throw new DatabaseIOException("updateObject failed on " + object.getObjectId() + " " + exception);
                }
            }
        } else {
            throw new DatabaseIOException("Cannot specify null object in updateObject");
        }
    }

    public PersistentCapableIfc retrieveObject(long id) throws DatabaseIOException {
        PersistentCapableIfc object = null;
        if (id > 0L) {
            ObjectId oid = new ObjectId(id);
            if (this.locallyDeletedObjects_.get(oid) != null) {
                throw new DatabaseIOException("Cannot retrieve a deleted object " + oid);
            }
            if (this.locallyAccessedObjects_.containsKey(oid)) {
                object = (PersistentCapableIfc)this.locallyAccessedObjects_.get(oid);
            } else {
                object = (PersistentCapableIfc)this.database_.readObject(id);
                if (object != null) {
                    this.locallyAccessedObjects_.put(oid, object);
                }
            }
        }
        return object;
    }

    void begin() {
        this.clear();
    }

    void commit() throws DatabaseIOException {
        try {
            Enumeration tranlog = null;
            tranlog = this.objectTranLog_.keys();
            while (tranlog.hasMoreElements()) {
                ObjectId oid = null;
                try {
                    oid = (ObjectId)tranlog.nextElement();
                    TranLogEntry entry = (TranLogEntry)this.objectTranLog_.get(oid);
                    if (entry.type_ == 3L || entry.type_ == 1L) {
                        PersistentCapableIfc original_obj = (PersistentCapableIfc)this.database_.readObject(entry.object_.getObjectId().getId());
                        if (original_obj.getObjectVersion().equals(entry.object_.getObjectVersion())) {
                            long version = entry.object_.getObjectVersion().getVersion();
                            entry.object_.getObjectVersion().setVersion(++version);
                            this.database_.update(entry.object_);
                            continue;
                        }
                        throw new DatabaseIOException("Failed to commit " + entry.object_ + " since version num. differs" + original_obj.getObjectVersion() + " with " + entry.object_.getObjectVersion());
                    }
                    if (entry.type_ == 2L) {
                        this.database_.delete(entry.object_);
                        continue;
                    }
                    _log.fatal((Object)("The TranLogEntry type " + entry.type_ + " is not supported"));
                }
                catch (Exception exception) {
                    throw new DatabaseIOException("Failed to commit " + exception);
                }
            }
            if (this.modifiedRootTable_) {
                try {
                    this.database_.setNamedRootTable(this.rootTable_);
                }
                catch (IOException exception) {
                    _log.fatal((Object)"FAILED TO UPDATE NAMED ROOT TABLE");
                    throw new DatabaseIOException(exception.toString());
                }
            }
            Object var8_8 = null;
            this.releaseLocalLocks();
            this.clear();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.releaseLocalLocks();
            this.clear();
            throw throwable;
        }
    }

    void abort() throws DatabaseIOException {
        try {
            Enumeration tranlog = null;
            tranlog = this.objectTranLog_.keys();
            while (tranlog.hasMoreElements()) {
                ObjectId oid = null;
                try {
                    oid = (ObjectId)tranlog.nextElement();
                    TranLogEntry entry = (TranLogEntry)this.objectTranLog_.get(oid);
                    if (entry.type_ == 1L) {
                        this.database_.delete(entry.object_);
                        continue;
                    }
                    if (entry.type_ == 2L || entry.type_ == 3L) continue;
                    _log.fatal((Object)("The TranLogEntry type " + entry.type_ + " is not supported"));
                }
                catch (Exception exception) {
                    _log.fatal((Object)("COMMIT FALIED on OID " + oid.getId() + " with exception " + exception));
                    throw new DatabaseIOException("Failed to commit " + exception);
                }
            }
            Object var5_5 = null;
            this.releaseLocalLocks();
            this.clear();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseLocalLocks();
            this.clear();
            throw throwable;
        }
    }

    void clear() {
        this.objectTranLog_.clear();
        this.locallyAccessedObjects_.clear();
        this.locallyDeletedObjects_.clear();
        this.sessionLocks_.clear();
        this.rootTable_ = null;
        this.modifiedRootTable_ = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lock acquireObjectLock(PersistentCapableIfc object, int timeout) throws FailedToAcquireLockException, FailedToCreateLockException {
        Lock obj_lock = null;
        if (object != null) {
            obj_lock = this.getLock(object);
            if (obj_lock == null) {
                obj_lock = this.createLock(object);
            }
            try {
                if (!obj_lock.hasLock(this)) {
                    obj_lock.acquire(this, timeout);
                    this.sessionLocks_.addElement(obj_lock);
                }
            }
            catch (Exception exception) {
                throw new FailedToAcquireLockException("Failed to acquire lock on " + object.toString() + " because " + exception);
            }
            try {
                PersistentCapableIfc original_obj = (PersistentCapableIfc)this.database_.readObject(object.getObjectId().getId());
                if (original_obj == null) return obj_lock;
                object.getObjectVersion().setVersion(original_obj.getObjectVersion().getVersion());
                return obj_lock;
            }
            catch (DatabaseIOException exception) {
                throw new FailedToAcquireLockException("Failed to acquire lock on " + object.toString() + " because " + exception);
            }
        }
        _log.error((Object)"Trying to acquireLock on null object");
        throw new FailedToAcquireLockException("Null object specfied acquireLock");
    }

    Lock acquireRootLock() throws FailedToAcquireLockException, FailedToCreateLockException {
        return this.acquireObjectLock(this.getNamedRootTable(), 5000);
    }

    synchronized PMDRootTable getNamedRootTable() {
        if (this.rootTable_ == null) {
            this.rootTable_ = (PMDRootTable)this.database_.getNamedRootTable().clone();
        }
        return this.rootTable_;
    }

    protected Lock getLock(PersistentCapableIfc object) {
        Lock result = null;
        Hashtable hashtable = locks__;
        synchronized (hashtable) {
            if (locks__.containsKey(object.getObjectId())) {
                result = (Lock)locks__.get(object.getObjectId());
            }
        }
        return result;
    }

    protected Lock createLock(PersistentCapableIfc object) throws FailedToCreateLockException {
        Lock result = null;
        Hashtable hashtable = locks__;
        synchronized (hashtable) {
            if (locks__.containsKey(object.getObjectId())) {
                throw new FailedToCreateLockException("Lock already exists on object id " + object.getObjectId());
            }
            Lock lock = new Lock(object);
            locks__.put(object.getObjectId(), lock);
            result = lock;
        }
        return result;
    }

    protected void deleteLock(PersistentCapableIfc object) {
        Hashtable hashtable = locks__;
        synchronized (hashtable) {
            this.deleteLock((Lock)locks__.get(object.getObjectId()));
        }
    }

    protected void deleteLock(Lock lock) {
        if (lock != null && !lock.anyTxWaiting()) {
            locks__.remove(lock.getObject().getObjectId());
        }
    }

    protected void releaseLocalLocks() {
        Enumeration locks = this.sessionLocks_.elements();
        while (locks.hasMoreElements()) {
            Lock lock = (Lock)locks.nextElement();
            lock.release(this);
            this.deleteLock(lock);
        }
        this.sessionLocks_.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class TranLogEntry {
        long type_;
        PersistentCapableIfc object_;
        public static final int CREATED = 1;
        public static final int DELETED = 2;
        public static final int UPDATED = 3;

        TranLogEntry(int type, PersistentCapableIfc object) {
            this.type_ = type;
            this.object_ = object;
        }
    }
}

