/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.database.recman;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.database.recman.PMDCollectionManager;
import org.exolab.core.database.recman.PMDHandle;
import org.exolab.core.database.recman.PMDTransactionCache;
import org.exolab.core.database.recman.PageManagedDatabase;
import org.exolab.core.foundation.CollectionManagerIfc;
import org.exolab.core.foundation.DatabaseIOException;
import org.exolab.core.foundation.DatabaseIfc;
import org.exolab.core.foundation.FailedToAcquireLockException;
import org.exolab.core.foundation.FailedToCreateHandleException;
import org.exolab.core.foundation.FailedToCreateLockException;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.core.foundation.ObjectNameExistsException;
import org.exolab.core.foundation.ObjectNameNotFoundException;
import org.exolab.core.foundation.PersistentCapableIfc;
import org.exolab.core.foundation.SessionIfc;
import org.exolab.core.foundation.SessionManagerIfc;
import org.exolab.core.foundation.TransactionContext;
import org.exolab.core.foundation.TransactionException;
import org.exolab.core.foundation.TransactionIfc;
import org.exolab.core.foundation.TransactionInProgressException;
import org.exolab.core.foundation.TransactionNotInProgressException;
import org.exolab.core.foundation.TransactionStatus;

public class PMDSession
implements SessionIfc,
TransactionIfc {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$database$recman$PMDSession == null ? (class$org$exolab$core$database$recman$PMDSession = PMDSession.class$("org.exolab.core.database.recman.PMDSession")) : class$org$exolab$core$database$recman$PMDSession));
    private transient long sessionId_ = -1L;
    private transient boolean rollbackOnly_ = false;
    private transient SessionManagerIfc sessionMgr_ = null;
    private transient TransactionStatus txStatus_ = TransactionStatus.CLOSED;
    private transient PMDTransactionCache cache_ = null;
    static /* synthetic */ Class class$org$exolab$core$database$recman$PMDSession;

    PMDSession(SessionManagerIfc manager, PageManagedDatabase database) {
        this.sessionMgr_ = manager;
        this.cache_ = new PMDTransactionCache(database);
        this.txStatus_ = TransactionStatus.CLOSED;
    }

    public Enumeration getRootNames() {
        return this.cache_.getRootNames();
    }

    public void bind(String name, PersistentCapableIfc object) throws ObjectNameExistsException, DatabaseIOException, TransactionNotInProgressException {
        if (this.txStatus_.isOpened()) {
            this.acquireRootLock();
            if (this.cache_.containsRoot(name)) {
                throw new ObjectNameExistsException("bind failed since " + name + " already exists.");
            }
        } else {
            throw new TransactionNotInProgressException("Must be in a transaction");
        }
        this.cache_.createRoot(name, object);
    }

    public void unbind(String name) throws ObjectNameNotFoundException, DatabaseIOException, TransactionNotInProgressException {
        if (this.txStatus_.isOpened()) {
            this.acquireRootLock();
            if (!this.cache_.containsRoot(name)) {
                throw new ObjectNameNotFoundException("unbind failed since " + name + " does not exists.");
            }
        } else {
            throw new TransactionNotInProgressException("Must be in a transaction");
        }
        this.cache_.deleteRoot(name);
    }

    public PersistentCapableIfc lookup(String name) {
        PersistentCapableIfc result = null;
        try {
            result = this.cache_.lookup(name);
        }
        catch (Exception exception) {
            _log.error((Object)exception);
        }
        return result;
    }

    public boolean isBound(String name) {
        boolean result = false;
        if (this.lookup(name) != null) {
            result = true;
        }
        return result;
    }

    public void acquireLock(PersistentCapableIfc object, int timeout) throws FailedToAcquireLockException, FailedToCreateLockException, TransactionNotInProgressException {
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Must be in a transaction");
        }
        this.cache_.acquireObjectLock(object, timeout);
    }

    public void begin() throws TransactionInProgressException {
        if (this.txStatus_.isOpened()) {
            _log.error((Object)("begin failed. Status of transaction is " + this.txStatus_));
            throw new TransactionInProgressException("status of the tx is " + this.txStatus_);
        }
        this.cache_.begin();
        this.txStatus_ = TransactionStatus.OPENED;
        this.rollbackOnly_ = false;
    }

    public void commit() throws TransactionNotInProgressException, TransactionException, DatabaseIOException {
        if (this.txStatus_.isOpened()) {
            if (this.rollbackOnly_) {
                this.rollback();
                throw new TransactionException("Transaction was forced to rollback in commit");
            }
        } else {
            _log.error((Object)("commit failed. The status of the tx is " + this.txStatus_));
            throw new TransactionNotInProgressException("commit failed, tx status " + this.txStatus_);
        }
        this.cache_.commit();
        this.txStatus_ = TransactionStatus.COMMITTED;
    }

    public void abort() throws TransactionNotInProgressException, DatabaseIOException {
        if (!this.txStatus_.isOpened()) {
            _log.error((Object)("abort failed. The status of the tx is " + this.txStatus_));
            throw new TransactionNotInProgressException("abort failed, tx status " + this.txStatus_);
        }
        this.txStatus_ = TransactionStatus.ABORTED;
        this.cache_.abort();
    }

    public void rollback() throws TransactionNotInProgressException, DatabaseIOException {
        this.abort();
    }

    public void setRollbackOnly(boolean status) throws TransactionNotInProgressException {
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Can't call setRollbackOnly if there is no tx in progress");
        }
        this.rollbackOnly_ = status;
    }

    public boolean isOpened() {
        return this.txStatus_.isOpened();
    }

    public TransactionContext getTransactionContext() {
        return this.cache_;
    }

    public TransactionIfc getCurrentTransaction() {
        return this;
    }

    public DatabaseIfc getDatabase() {
        return this.cache_.getDatabase();
    }

    public SessionManagerIfc getSessionManager() {
        return this.sessionMgr_;
    }

    public void setSessionManager(SessionManagerIfc manager) {
        this.sessionMgr_ = manager;
    }

    public void createObject(PersistentCapableIfc object) throws TransactionNotInProgressException, DatabaseIOException {
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Can't call createObject if there is no tx in progress");
        }
        this.cache_.createObject(object);
    }

    public void updateObject(PersistentCapableIfc object) throws TransactionNotInProgressException, DatabaseIOException {
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Can't call updateObject if there is no tx in progress");
        }
        this.cache_.updateObject(object);
    }

    public void deleteObject(PersistentCapableIfc object) throws TransactionNotInProgressException, DatabaseIOException {
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Can't call deleteObject if there is no tx in progress");
        }
        this.cache_.deleteObject(object);
    }

    public PersistentCapableIfc retrieveObject(long id) throws TransactionNotInProgressException, DatabaseIOException {
        PersistentCapableIfc object = null;
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Can't call retrieveObject if there is no tx in progress");
        }
        object = this.cache_.retrieveObject(id);
        return object;
    }

    public HandleIfc createHandle(PersistentCapableIfc object) throws FailedToCreateHandleException, TransactionNotInProgressException {
        PMDHandle handle = null;
        if (!this.txStatus_.isOpened()) {
            throw new TransactionNotInProgressException("Can't call createHandle if there is no tx in progress");
        }
        handle = new PMDHandle(object);
        return handle;
    }

    public CollectionManagerIfc getCollectionManager() {
        return PMDCollectionManager.instance();
    }

    public long getSessionId() {
        return this.sessionId_;
    }

    public boolean isValid() {
        return this.sessionId_ > 0L;
    }

    void setSessionId(long id) {
        this.sessionId_ = id;
    }

    void acquireRootLock() throws DatabaseIOException {
        try {
            this.cache_.acquireRootLock();
        }
        catch (Exception exception) {
            _log.error((Object)exception);
            throw new DatabaseIOException("Error in acquireRootLock " + exception.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

