/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.database.recman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LockManager
implements Runnable {
    private HashMap _locks = new HashMap();
    private long _interval = 120000L;
    private boolean _disableExpiry = false;
    private static LockManager _instance = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$database$recman$LockManager == null ? (class$org$exolab$core$database$recman$LockManager = LockManager.class$("org.exolab.core.database.recman.LockManager")) : class$org$exolab$core$database$recman$LockManager));
    private static final long DEFAULT_INTERVAL = 120000L;
    private static final String INTERVAL = "org.exolab.core.database.recman.lockRefreshInterval";
    private static final String DISABLE_EXPIRY = "org.exolab.core.database.recman.disableExpiry";
    static /* synthetic */ Class class$org$exolab$core$database$recman$LockManager;

    private LockManager() {
        Integer interval = Integer.getInteger(INTERVAL);
        if (interval != null && interval >= 30) {
            this._interval = interval * 1000;
        }
        _log.debug((Object)("Lock refresh interval=" + this._interval / 1000L));
        if (System.getProperty(DISABLE_EXPIRY) != null) {
            this._disableExpiry = true;
        }
        if (!this._disableExpiry) {
            Thread thread = new Thread((Runnable)this, "PMD-LockManager");
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.start();
        } else {
            _log.debug((Object)"Lock expiry is disabled");
        }
    }

    public static synchronized LockManager getInstance() {
        if (_instance == null) {
            _instance = new LockManager();
        }
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void acquire(String name) throws IOException {
        String lockName = this.getLockName(name);
        File lock = new File(lockName);
        if (lock.exists()) {
            if (this._disableExpiry) throw new IOException("Cannot acquire lock=" + lockName + " - a lock already exists");
            long time = this.read(lock);
            if (this.expired(time)) {
                _log.debug((Object)("Removing expired lock file: " + lockName));
                lock.delete();
            } else {
                DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
                throw new IOException("Cannot acquire lock=" + lockName + " - a lock exists that will expire at " + formatter.format(new Date(time)));
            }
        }
        if (!lock.createNewFile()) {
            throw new IOException("Cannot acquire lock for name=" + name);
        }
        lock.deleteOnExit();
        _log.debug((Object)("Acquiring lock=" + lockName));
        this.write(lock);
        this._locks.put(name, lock);
    }

    public synchronized void release(String name) throws IOException {
        String lockName = this.getLockName(name);
        File lock = (File)this._locks.remove(name);
        if (lock == null) {
            throw new IOException("Lock=" + lockName + " does not exist");
        }
        _log.debug((Object)("Releasing lock=" + lockName));
        lock.delete();
    }

    public void run() {
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(this._interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.refreshLocks();
        }
    }

    private boolean expired(long time) {
        long now = System.currentTimeMillis();
        return now > time;
    }

    private synchronized void refreshLocks() {
        Iterator iter = this._locks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            File lock = (File)entry.getValue();
            this.refreshLock(name, lock);
        }
    }

    private void refreshLock(String name, File lock) {
        String lockName = this.getLockName(name);
        _log.debug((Object)("Refreshing lock=" + lockName));
        try {
            this.write(lock);
        }
        catch (IOException exception) {
            _log.error((Object)("Failed to refresh lock=" + lockName), (Throwable)exception);
        }
    }

    private void write(File lock) throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(lock));
        long expiry = System.currentTimeMillis() + this._interval * 2L;
        stream.writeLong(expiry);
        stream.close();
    }

    private long read(File lock) throws IOException {
        ObjectInputStream stream = new ObjectInputStream(new FileInputStream(lock));
        long result = stream.readLong();
        stream.close();
        return result;
    }

    private String getLockName(String name) {
        return name + ".lock";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

